/*
 * UiComponentHelper.java  
 *
 * Creator:
 * 22.05.2007 15:55:03 Sippel
 *
 * Maintainer:
 * 22.05.2007 15:55:03 Sippel
 *
 * Last Modification:
 * $Id: $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */
package ch.abacus.testapp;

import javax.swing.*;
import javax.swing.border.Border;
import java.awt.*;

public class UiComponentHelper {

    static public JButton getButton(String defaultText, int width) {
        JButton btn = new JButton();
        btn.setMaximumSize(new Dimension(width,20));
        btn.setMinimumSize(new Dimension(width,20));
        btn.setPreferredSize(new Dimension(width,20));
        btn.setText(defaultText);
        return btn;
    }

    static public JCheckBox getCheckBox(String defaultText, int width) {
        JCheckBox chkb = new JCheckBox();
        int preferredWidth = width;
        int maxWidth = width;
        int minWidth = width;
        if ( width <= 10 ) {
            preferredWidth = 1100;
            maxWidth = 9999;
            minWidth = 10;
        }
        chkb.setMaximumSize(new Dimension(maxWidth,20));
        chkb.setMinimumSize(new Dimension(minWidth,20));
        chkb.setPreferredSize(new Dimension(preferredWidth,20));
        chkb.setText(defaultText);
        return chkb;
    }

    static public JPanel getLinePanel(int fixedHeight) {
        JPanel pnlLine = getPanelWithBoxLayout(BoxLayout.LINE_AXIS,-1,fixedHeight);
        return pnlLine;
    }

    static public JPanel getHorizontalSpacer() {
        JPanel pnlLine = new JPanel();
        pnlLine.setLayout(new BoxLayout(pnlLine,BoxLayout.LINE_AXIS));
        pnlLine.setMaximumSize(new Dimension(9999,2));
        pnlLine.setMinimumSize(new Dimension(2,2));
        pnlLine.setPreferredSize(new Dimension(999,2));
        return pnlLine;
    }

    static public JPanel getVerticalSpacer() {
        JPanel pnlLine = new JPanel();
        pnlLine.setLayout(new BoxLayout(pnlLine,BoxLayout.PAGE_AXIS));
        pnlLine.setMaximumSize(new Dimension(2,9999));
        pnlLine.setMinimumSize(new Dimension(2,2));
        pnlLine.setPreferredSize(new Dimension(2,700));
        return pnlLine;
    }


    static public JPanel getPanelWithBoxLayout(int boxLayoutAxis, int fixedWidth, int fixedHeight) {
        return getPanelWithBoxLayout(boxLayoutAxis, fixedWidth, fixedHeight, -1, -1);
    }

    static public JPanel getPanelWithBoxLayout(int boxLayoutAxis, int fixedWidth, int fixedHeight, int preferredWidth, int preferredHeight) {
        JPanel pnl = new JPanel();
//        pnl.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        int minHeight = 10;
        int minWidth = 10;
        int maxHeight = 9999;
        int maxWidth = 9999;
        int prefHeight = 800;
        int prefWidth = 1100;
        if ( fixedWidth > 0 ) {
            minWidth = fixedWidth;
            maxWidth = fixedWidth;
            prefWidth = fixedWidth;
        }
        if ( fixedHeight > 0 ) {
            minHeight = fixedHeight;
            maxHeight = fixedHeight;
            prefHeight = fixedHeight;
        }
        if ( preferredWidth > 0 ) {
            prefWidth = preferredWidth;
        }
        if ( preferredHeight > 0 ) {
            prefHeight = preferredHeight;
        }
        pnl.setLayout(new BoxLayout(pnl,boxLayoutAxis));
        pnl.setMinimumSize(new Dimension(minWidth, minHeight));
        pnl.setMaximumSize(new Dimension(maxWidth, maxHeight));
        pnl.setPreferredSize(new Dimension(prefWidth, prefHeight));
        return pnl;
    }


    static public JPanel getFixedSizePanel(int width, int height, boolean pageAxisLayout) {
        JPanel pnlLine = new JPanel();
        if ( pageAxisLayout ) {
            pnlLine.setLayout(new BoxLayout(pnlLine,BoxLayout.PAGE_AXIS));
        } else {
            pnlLine.setLayout(new BoxLayout(pnlLine,BoxLayout.LINE_AXIS));
        }
        pnlLine.setMaximumSize(new Dimension(width,height));
        pnlLine.setMinimumSize(new Dimension(width,height));
        pnlLine.setPreferredSize(new Dimension(width,height));
        return pnlLine;
    }

    static public JTextField getTextField(String defaultText, int width) {
        int preferredWidth = width;
        int maxWidth = width;
        int minWidth = width;
        if ( width <= 10 ) {
            preferredWidth = 1100;
            maxWidth = 9999;
            minWidth = 10;
        }
        JTextField txf = new JTextField();
        txf.setMaximumSize(new Dimension(maxWidth,20));
        txf.setMinimumSize(new Dimension(minWidth,20));
        txf.setPreferredSize(new Dimension(preferredWidth,20));
        txf.setText(defaultText);
        return txf;
    }

    static public JLabel getLabel(String defaultText, int fixedWidth) {
        int maxWidth = fixedWidth;
        int minWidth = fixedWidth;
        int prefWidth = fixedWidth;
        if ( maxWidth <= 0 ) {
            maxWidth = 9999;
            minWidth = 10;
            prefWidth = 1100;
        }
        JLabel lbl = new JLabel();
        lbl.setMaximumSize(new Dimension(maxWidth,20));
        lbl.setMinimumSize(new Dimension(minWidth,20));
        lbl.setPreferredSize(new Dimension(prefWidth,20));
        lbl.setText(defaultText);
        return lbl;
    }


}
