/*
 * AbaViewReportType.java  
 *
 * Creator:
 * 4/07/13 12:02 PM Sippel
 *
 * Maintainer:
 * 4/07/13 12:02 PM Sippel
 *
 * Last Modification:
 * $Id: $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */
package ch.abacus.testapp;

import java.util.ArrayList;

/*
  Pdf("pdf", "pdf"),
  Text("txt", "txt"),
  PrintText("print-txt", "txt"),
  TextAll("txt_all", "txt"),
  PrintTextEndless("print-text_endless", "txt"),
  HtmlEndless("html_endless", "html"),
  HtmlTable("html_table", "html"),
  HtmlAutoTable("html_autotable", "html"),
  ExcelData("excel-xlsx_data", "xlsx"),
  ExcelMatrix("excel-xlsx_matrix", "xlsx"),
  Excel("excel-xlsx", "xls"),
  Word("word-docx", "docx"),
  XmlAttribute("xml_attr", "xml"),
  XmlValue("xml_value", "xml"),
  XmlNameValue("xml_namevalue", "xml"),
  XmlAv("xml_av", "xml"),
  XmlPreview("xml_preview", "xml");


// Documentation from AbaEngine WebService from http://localhost:40000/av/abaengine/soap/api_runreport.html
Typ 	        Beschreibung
txt * 	        Text-Export AbaView
html_endless 	HTML Seite
excel 	        Excel-Tabelle, AbaView Format (ab Office 2000)
excel_data 	    Excel-Tabelle, für jedes Feld wird eine eigene Spalte  generiert (ab Office 2000)
word 	        Word-Dokument (HTML-Format, das ab Office 2000 gelesen werden kann)
xml_attr * 	    XML
xml_value * 	 XML
xml_namevalue *  XML
xml_query * 	 XML
xml_av * 	    XML
print 	        Report wird ausgedruckt
adf 	        ADF (ABACUS Format)
pdf 	        PDF-Dokument

Bei den mit (*) markierten Typen kann zusätzlich noch ein Zeichensatz mitgegeben werden.
 */
public class AbaViewReportType implements Comparable {
    // This is the Enum defined in the ABACUS Enum class ch.abacus.ulc.server.report.abaengine.AbaEngineOutputDevice
    private String mAbaEngineOutputDevice;

    // This is the standard AbaView-Report Type used via WebService or with commandline calls
    private String mAbaReportType;

    // The File Extension for the result file
    private String mFileExtension;

    // The File Extension for the result file
    private ArrayList<String> mEncodings = new ArrayList<String>();

    public AbaViewReportType(String abaEngineOutputDevice, String abaReportType, String fileExtension) {
        this(abaEngineOutputDevice, abaReportType, fileExtension, null);
    }

    public AbaViewReportType(String abaEngineOutputDevice, String abaReportType, String fileExtension, String[] encodings) {
        mAbaEngineOutputDevice = abaEngineOutputDevice;
        mAbaReportType = abaReportType;
        mFileExtension = fileExtension;
        if ( encodings != null ) {
            if ( encodings.length > 0 ) {
                for( String encVal : encodings ) {
                    if ( !mEncodings.contains(encVal) ) {
                        mEncodings.add(encVal);
                    }
                }
            }
        }
    }

    public String getAbaEngineOutputDevice() {
        return mAbaEngineOutputDevice;
    }

    public String getAbaReportType() {
        return mAbaReportType;
    }

    public String getFileExtension() {
        return mFileExtension;
    }

    @Override
    public String toString() {
        return getAbaReportType();
    }

    @Override
    public int compareTo(Object other) {
        if ( other == null ) return 0;
        return toString().compareTo(other.toString());
    }

    public boolean hasEncodings() {
        if ( mEncodings == null ) return false;
        return (mEncodings.size() > 0);
    }

    public boolean supportsEncoding(String encoding) {
        if ( mEncodings != null && encoding != null && !"".equals(encoding) ) {
            if ( mEncodings.size() > 0 ) {
                for( String encVal : mEncodings ) {
                    if ( encoding.equalsIgnoreCase(encVal) ) {
                        return true;
                    }
                }
            }
        }
        return false;
    }
}
