/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.xmltools;

import java.io.CharArrayWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public abstract class TestSaxParser
implements ContentHandler,
ErrorHandler {
    XMLReader m_XMLReader;
    public CharArrayWriter elementValue = new CharArrayWriter();

    @Override
    public void characters(char[] cArray, int n, int n2) {
        this.elementValue.write(cArray, n, n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.endElement(string3, this.elementValue.toString());
        this.elementValue.reset();
    }

    public abstract void endElement(String var1, String var2);

    public void saxParse(String string) throws SAXException {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.saxParse(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("XML-File could not be found. The File is: " + string, fileNotFoundException);
        }
    }

    public void saxParse(InputStream inputStream) throws SAXException {
        InputSource inputSource = new InputSource(inputStream);
        this.saxParse(inputSource);
    }

    public void saxParse(Reader reader) throws SAXException {
        InputSource inputSource = new InputSource(reader);
        this.saxParse(inputSource);
    }

    public void saxParse(InputSource inputSource) throws SAXException {
        if (inputSource == null) {
            throw new NullPointerException("InputSource for TestSaxParser is NULL. Check if the specified XML file exists!");
        }
        try {
            XMLReader xMLReader = this.getReader();
            xMLReader.parse(inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("saxParse(FileInputStream) - ParserConfigurationException - the parser is configured in a wrong way", parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("saxParse(FileInputStream) - IOException", iOException);
        }
    }

    private XMLReader getReader() throws ParserConfigurationException, SAXException {
        if (this.m_XMLReader != null) {
            return this.m_XMLReader;
        }
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        this.m_XMLReader = sAXParser.getXMLReader();
        this.m_XMLReader.setContentHandler(this);
        this.m_XMLReader.setErrorHandler(this);
        this.m_XMLReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        return this.m_XMLReader;
    }

    protected boolean isValueBlankLine(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        if (!"".equals(string.trim())) {
            return false;
        }
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c == '\n' || c == '\r') {
                return true;
            }
            if (c == ' ') continue;
            return false;
        }
        return false;
    }

    public abstract void startElement(String var1, Attributes var2);

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this.startElement(string3, attributes);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void skippedEntity(String string) {
    }

    @Override
    public void startPrefixMapping(String string, String string2) {
    }

    @Override
    public void endPrefixMapping(String string) {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    @Override
    public void processingInstruction(String string, String string2) {
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        this.logError(sAXParseException);
    }

    @Override
    public void error(SAXParseException sAXParseException) {
        this.logError(sAXParseException);
        throw new RuntimeException("Error in TestSaxParser", sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.logError(sAXParseException);
        throw new RuntimeException("Fatal Error in TestSaxParser", sAXParseException);
    }

    protected void logError(SAXParseException sAXParseException) {
        System.out.println(sAXParseException + " in " + this.getClass() + " SAX parsing error: " + sAXParseException.getMessage());
        System.out.println("Exception at location: " + this.getLocationString(sAXParseException));
        sAXParseException.printStackTrace();
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }
}

