/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.testapp;

import ch.abacus.abaengine.AbaEngine;
import ch.abacus.abaengine.AbaEngineService;
import ch.abacus.abaengine.KeepAliveResult;
import ch.abacus.abaengine.ReportResult;
import ch.abacus.testapp.ACUtilities;
import ch.abacus.testapp.LoginDialog;
import ch.abacus.testapp.StandardExampleFrame;
import java.awt.Cursor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;

public class AbaEngineTest
extends StandardExampleFrame {
    private int mMaxOpenViewRowCount = 100;
    private int mStartTestSecondsActive = 0;
    private static final char DEFAULT_SEPARATOR = ',';
    private static final char DEFAULT_QUOTE = '\"';

    public static void main(String[] stringArray) {
        final AbaEngineTest abaEngineTest = new AbaEngineTest();
        abaEngineTest.initUI();
        String[] stringArray2 = new String[]{"abaengine"};
        abaEngineTest.setInterfaceNames(stringArray2);
        abaEngineTest.setTitle("AbaEngine / AbaView Example via Web Service JAVA with JAXWS" + ACUtilities.getCurrentProgramVersionInfo());
        abaEngineTest.setVisible(true);
        if (stringArray != null && stringArray.length > 0) {
            for (String string : stringArray) {
                if (!string.startsWith("-test")) continue;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        abaEngineTest.mStartTestSecondsActive = 3;
                        abaEngineTest.setupStartTestTimer();
                    }
                });
            }
        }
    }

    private void setupStartTestTimer() {
        if (this.isVisible() && this.mStartTestSecondsActive > 0) {
            final int n = this.mStartTestSecondsActive <= 60 ? this.mStartTestSecondsActive * 1000 : this.mStartTestSecondsActive;
            this.writeToOutputPane("TESTING : \n\nCurrent Working Directory : " + ACUtilities.getCurrentUserWorkingDirectory() + "\n\nINFO : Program will close automatically in " + String.format("%.1f", (double)n / 1000.0) + " seconds.  (TIME : " + ACUtilities.convertDateToTimeString(System.currentTimeMillis()) + ")");
            final Timer timer = new Timer();
            this.mStartTestSecondsActive = 0;
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    System.out.println("   * TIMER EXECUTED : Waiting " + String.format("%.1f", (double)n / 1000.0) + " seconds to close. (TIME : " + ACUtilities.convertDateToTimeString(System.currentTimeMillis()) + ")");
                    timer.cancel();
                    AbaEngineTest.this.setVisible(false);
                    AbaEngineTest.this.dispose();
                }
            }, n, (long)(n * 100));
        }
    }

    private void testCsvDecoding() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"ADR_INR,ADR_KURZNA,ADR_NAME,ADR_VORNAME,ADR_ORT,ADR_LAND,ADR_PLZ,ADR_MUTDATUM,ADR_GUID", "1,\"Field with, comma\",ABACUS DEMO AG,ABACUS Demo AG,,Wittenbach,CH,9300,21.11.2013 15:12:16,{31142122-620A-DF01-F998-000C2936F612}"}) {
            System.out.println("For CSV : " + string + "");
            String[] stringArray2 = AbaEngineTest.decodeCSVLine(9, string, ",");
            System.out.print("1: ");
            for (String string2 : stringArray2) {
                System.out.print(" >" + string2 + "<  ");
            }
            System.out.println();
            Object object = AbaEngineTest.parseLine(string, ',', '\"');
            System.out.print("2: ");
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                System.out.print(" >" + string3 + "<  ");
            }
            System.out.println();
            object = AbaEngineTest.parseLine2017(string, ',', '\"');
            System.out.print("3: ");
            iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                System.out.print(" >" + string4 + "<  ");
            }
            System.out.println();
        }
    }

    @Override
    public void action_getReportNames() {
        String string = "txt";
        this.action_ExportReport(this.getAbaViewReportNames(), string, "", "");
    }

    @Override
    public void action_runReport() {
        String string = this.getReportName();
        if ("".equals(string)) {
            this.showMessageBox("The Report Name is not defined.  Please enter a valid report name", "No Report Name");
            return;
        }
        if (!this.isQueryAsOpenView()) {
            String string2 = this.getSelectedAbaViewReportType();
            this.action_ExportReport(string, string2, this.getInputParameters(), this.getServerExportFileName());
        }
    }

    protected void setupWebServiceUrlBinding(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("The WebService Binding Stub Object parameter cannot be null !!");
        }
        BindingProvider bindingProvider = (BindingProvider)object;
        if (bindingProvider == null) {
            throw new IllegalArgumentException("The WebService Binding cannot be cast from Stub Object !!");
        }
        bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", this.getServiceUrl("abaengine"));
    }

    private boolean action_GetAbaViewReport(String string, String string2, String string3) {
        boolean bl = false;
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.getTableHeaderData().clear();
        this.getTableRowData().clear();
        this.clearInfo();
        long l = 0L;
        long l2 = System.currentTimeMillis();
        boolean bl2 = this.isLogSoapMessagesActive();
        String string4 = ACUtilities.getCurrentUserWorkingDirectory() + File.separator + "temp_SoapMessages.log";
        File file = new File(string4);
        if (file.exists() && !file.delete()) {
            this.writeToOutputPane("Warning : Soap Messaeg log file " + string4 + "could not be deleted");
        }
        int n = this.getTimeoutMillisecs();
        this.writeToOutputPane("Info : Using timeout " + n + " ms");
        this.writeToOutputPane("Starting query for report " + string + " in Mandant " + this.getCurrentMandant());
        try {
            Object object;
            String string5;
            File file2 = new File("e:\\dev\\abaengine_jaxws_2018_runReportOnly\\wsdl_runReportOnly\\abaengine_runReportOnly.wsdl");
            AbaEngineService abaEngineService = new AbaEngineService(file2.toURI().toURL(), new QName("urn:AbaEngine", "AbaEngineService"));
            AbaEngine abaEngine = abaEngineService.getAbaEnginePort();
            this.setupWebServiceUrlBinding(abaEngine);
            String string6 = abaEngine.login(this.getCurrentUserName(), this.getCurrentUserPassword());
            if (string6 == null || "".equals(string6)) {
                this.writeToOutputPane("Login unsuccessful");
                this.setCursor(cursor);
                return bl;
            }
            this.writeToOutputPane("Login successful  Token[" + string6 + "]");
            String string7 = string2;
            if (this.getReportSupportsEncoding(string7, "UTF-8")) {
                string7 = string7 + "/UTF-8";
            }
            String string8 = "";
            if (!ACUtilities.StringIsNullOrEmpty(string.trim())) {
                int n2;
                Object object2;
                this.writeToOutputPane("Info: Starting Query for Report[" + string + "]  " + (ACUtilities.StringIsNullOrEmpty(string3) ? "" : "InputParams[" + string3 + "]") + "");
                ReportResult reportResult = abaEngine.runReport(string6, string, string7, string3 == null ? "" : string3, "de", this.getCurrentMandant(), 0, n);
                int n3 = 0;
                while ("timeout".equals(reportResult.getStatus())) {
                    this.writeToOutputPane("    Timeout loop [" + ++n3 + "]  Session[" + reportResult.getSession() + "]   [" + (System.currentTimeMillis() - l2) + " ms]");
                    reportResult = abaEngine.retry(reportResult.getSession(), n);
                }
                string5 = "ok".equalsIgnoreCase(reportResult.getStatus()) ? "   Report finished - and being processed..." : "";
                this.writeToOutputPane("Total Timeout loops [" + n3 + "]" + string5);
                object = this.getReportFileExtension(string2);
                String string9 = ACUtilities.getCurrentUserWorkingDirectory() + File.separator + "temp_abaViewReport." + (String)object;
                boolean bl3 = false;
                String string10 = string8 = reportResult.getData() == null ? "" : new String(reportResult.getData(), "UTF-8");
                if ("ok".equals(reportResult.getStatus())) {
                    try {
                        object2 = new FileOutputStream(string9);
                        ((FileOutputStream)object2).write(reportResult.getData());
                        ((FileOutputStream)object2).close();
                        bl3 = new File(string9).exists();
                        this.writeToOutputPane("Report data saved to file : " + string9);
                    }
                    catch (IOException iOException) {
                        System.out.println("Exception : " + iOException.getMessage());
                        iOException.printStackTrace();
                    }
                    if ("txt".equals(string2)) {
                        this.writeToOutputPane("Retrieving report data...");
                        object2 = new StringTokenizer(string8, "\r\n");
                        n2 = 0;
                        while (((StringTokenizer)object2).hasMoreTokens()) {
                            String string11 = ((StringTokenizer)object2).nextToken();
                            String[] stringArray = AbaEngineTest.decodeCSVLine(n2, string11, ",");
                            if (n2 <= 0) {
                                n2 = stringArray.length;
                                for (String string12 : stringArray) {
                                    this.getTableHeaderData().add(AbaEngineTest.removeQuotes(string12));
                                }
                                continue;
                            }
                            String[] stringArray2 = new Vector();
                            for (String string13 : stringArray) {
                                stringArray2.add(AbaEngineTest.removeQuotes(string13));
                            }
                            this.getTableRowData().add(stringArray2);
                            ++l;
                        }
                        this.writeToOutputPane("Number of returned rows in report [" + this.getTableRowData().size() + "]");
                    } else {
                        this.getTableHeaderData().add("Information");
                        object2 = new Vector();
                        ((Vector)object2).add("INFO : Report with type \"" + string2 + "\" will not be shown as table data.");
                        this.getTableRowData().add(object2);
                        if (bl3) {
                            object2 = new Vector<String>();
                            ((Vector)object2).add("Report file saved as : " + string9);
                            this.getTableRowData().add(object2);
                        }
                        this.writeToOutputPane("Report data is only shown in the above window for TEXT format.");
                    }
                    bl = true;
                } else {
                    this.writeToOutputPane("Ein Fehler ist aufgetreten: ");
                    if (!ACUtilities.StringIsNullOrEmpty(string8)) {
                        this.writeToOutputPane("------------------------------------");
                        this.writeToOutputPane(string8);
                        this.writeToOutputPane("------------------------------------");
                    }
                    if (string.equals(this.getAbaViewReportNames())) {
                        this.writeToOutputPane("Note : In ABACUS V2016 and later it is not possible to query the report names list with : " + this.getAbaViewReportNames());
                        this.writeToOutputPane("The name of the report on the server must be known.");
                    }
                }
                if (string.equals(this.getAbaViewReportNames())) {
                    this.setAbaViewReportNamesActive(this.getTableRowData().size() > 0);
                } else {
                    this.setAbaViewReportNamesActive(false);
                }
                if (!"".equals(reportResult.getSession())) {
                    object2 = abaEngine.keepAlive(reportResult.getSession());
                    if (((KeepAliveResult)object2).getTimeToLive() == 0 || "".equals(((KeepAliveResult)object2).getSession())) {
                        this.writeToOutputPane("The session is finished.");
                    }
                    n2 = abaEngine.close(reportResult.getSession());
                    this.writeToOutputPane("Session Close returned [" + (n2 != 0 ? "TRUE" : "FALSE") + "]");
                }
            }
            boolean bl4 = abaEngine.logout(string6);
            this.writeToOutputPane("Logout - returned [" + (bl4 ? "TRUE" : "FALSE") + "]  LoginToken[" + string6 + "]");
            String string14 = "";
            if (string14 != null && !"".equals(string14)) {
                try {
                    string5 = "UTF-8";
                    object = new FileOutputStream(string4);
                    ((FileOutputStream)object).write(string14.getBytes(string5));
                    ((FileOutputStream)object).write("\n\n".getBytes(string5));
                    ((FileOutputStream)object).write("Returned Report Data (decoded)\n==============================================\n".getBytes(string5));
                    ((FileOutputStream)object).write(string8.getBytes(string5));
                    ((FileOutputStream)object).write("\n----------------------------------------------\n".getBytes(string5));
                    ((FileOutputStream)object).close();
                    this.writeToOutputPane("SOAP Messages saved to file : " + string4);
                }
                catch (IOException iOException) {
                    System.out.println("Exception : " + iOException.getMessage());
                    iOException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            this.writeToOutputPane("ERROR : An Exception occurred will accessing the report !");
            this.writeToOutputPane("Exception : " + exception.getMessage());
            exception.printStackTrace();
        }
        this.setCursor(cursor);
        long l3 = System.currentTimeMillis();
        this.writeToOutputPane(this.getTimingReport("AbaReport " + string2 + " Timing Report", l2, l3, l));
        this.refreshReportTable();
        this.scrollOutputPaneToStart();
        return bl;
    }

    private void action_ExportReport(String string, String string2, String string3, String string4) {
        if (string == null || "".equals(string)) {
            return;
        }
        boolean bl = this.isQueryAsOpenView() && !string.equals(this.getAbaViewReportNames());
        boolean bl2 = false;
        if (!this.isShowLoginOnceSelected() || this.getLoginCount() == 0) {
            LoginDialog loginDialog = new LoginDialog(this);
            loginDialog.setUserName(this.getCurrentUserName());
            loginDialog.setPassword(this.getCurrentUserPassword());
            loginDialog.setMandant(this.getCurrentMandant());
            loginDialog.setLocation(this.getX() + 100, this.getY() + 50);
            loginDialog.setModal(true);
            loginDialog.setVisible(true);
            if (!loginDialog.isDialogEndedWithOK()) {
                return;
            }
            this.setCurrentUserName(loginDialog.getUserName());
            this.setCurrentUserPassword(loginDialog.getPassword());
            this.setCurrentMandant(loginDialog.getMandant());
            this.incrementLoginCount();
            if (!bl && (bl2 = this.action_GetAbaViewReport(string, string2, string3))) {
                this.action_ExportAbaViewReportToServerFile(string, string2, string3, string4);
            }
        } else if (!bl && (bl2 = this.action_GetAbaViewReport(string, string2, string3))) {
            this.action_ExportAbaViewReportToServerFile(string, string2, string3, string4);
        }
        if (bl2) {
            this.addReportName(string);
        }
    }

    private boolean action_ExportAbaViewReportToServerFile(String string, String string2, String string3, String string4) {
        boolean bl = false;
        if (string4 == null || "".equals(string4)) {
            return bl;
        }
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        int n = this.getTimeoutMillisecs();
        this.writeToOutputPane("Info : Using timeout " + n + " ms");
        this.writeToOutputPane("Exporting Report to file : " + string4);
        this.writeToOutputPane("Starting query for export report " + string + " in Mandant " + this.getCurrentMandant());
        boolean bl2 = this.isLogSoapMessagesActive();
        String string5 = ACUtilities.getCurrentUserWorkingDirectory() + File.separator + "temp_SoapMessages.log";
        File file = new File(string5);
        if (file.exists() && !file.delete()) {
            this.writeToOutputPane("Warning : Soap Messaeg log file " + string5 + "could not be deleted");
        }
        String string6 = "";
        try {
            Object object;
            String string7;
            AbaEngineService abaEngineService = new AbaEngineService(new URL("e:\\dev\\abaengine_jaxws_2018_runReportOnly\\wsdl_runReportOnly\\abaengine_runReportOnly.wsdl"), new QName("http://www.abacus.ch/abaconnect/AbaEngine", "AbaEngine"));
            AbaEngine abaEngine = abaEngineService.getAbaEnginePort();
            String string8 = abaEngine.login(this.getCurrentUserName(), this.getCurrentUserPassword());
            if (string8 == null || "".equals(string8)) {
                this.writeToOutputPane("Login unsuccessful");
                this.setCursor(cursor);
                return bl;
            }
            this.writeToOutputPane("Login successful  Token[" + string8 + "]");
            String string9 = string2;
            if (this.getReportSupportsEncoding(string9, "UTF-8")) {
                string9 = string9 + "/UTF-8";
            }
            if (!ACUtilities.StringIsNullOrEmpty(string.trim())) {
                ReportResult reportResult = abaEngine.exportToFile(string8, string, string4, string9, string3 == null ? "" : string3, "de", this.getCurrentMandant(), 0, n);
                int n2 = 0;
                while ("timeout".equals(reportResult.getStatus())) {
                    reportResult = abaEngine.retry(reportResult.getSession(), n);
                    this.writeToOutputPane("    Timeout loop [" + ++n2 + "]");
                }
                string7 = "ok".equalsIgnoreCase(reportResult.getStatus()) ? "   Report finished." : "";
                this.writeToOutputPane("Total Timeout loops [" + n2 + "]" + string7);
                String string10 = string6 = reportResult.getData() == null ? "" : new String(reportResult.getData(), "UTF-8");
                if ("ok".equals(reportResult.getStatus())) {
                    this.writeToOutputPane("The AbaView Report was successfully exported to the file : " + string4);
                    bl = true;
                    if (!string4.contains(":")) {
                        this.writeToOutputPane("Info : Export file name [" + string4 + "] has no path.  Default path on server");
                        this.writeToOutputPane("          may be a Window System directory (e.g. c:\\windows\\system32\\" + string4 + ")");
                    }
                } else {
                    this.writeToOutputPane("ERROR: An error occurred exporting the AbaView Report to the file : " + string4);
                }
                if (!"".equals(reportResult.getSession())) {
                    object = abaEngine.keepAlive(reportResult.getSession());
                    if (((KeepAliveResult)object).getTimeToLive() == 0 || "".equals(((KeepAliveResult)object).getSession())) {
                        this.writeToOutputPane("The session is finished.");
                    }
                    boolean bl3 = abaEngine.close(reportResult.getSession());
                    this.writeToOutputPane("Session Close returned [" + (bl3 ? "TRUE" : "FALSE") + "]");
                }
            } else {
                this.writeToOutputPane("Info : No Report requested, because the the Report Name is not defined.");
                this.writeToOutputPane("Info : Only the login and logout functionality was tested.");
            }
            boolean bl4 = abaEngine.logout(string8);
            this.writeToOutputPane("Logout - returned [" + (bl4 ? "TRUE" : "FALSE") + "]  LoginToken[" + string8 + "]");
            String string11 = "";
            if (string11 != null && !"".equals(string11)) {
                try {
                    string7 = "UTF-8";
                    object = new FileOutputStream(string5);
                    ((FileOutputStream)object).write(string11.getBytes("UTF-8"));
                    ((FileOutputStream)object).write("\n\n".getBytes());
                    ((FileOutputStream)object).write("Returned Report Data (decoded)\n==============================================\n".getBytes());
                    ((FileOutputStream)object).write(string6.getBytes());
                    ((FileOutputStream)object).write("\n----------------------------------------------\n".getBytes());
                    ((FileOutputStream)object).close();
                    this.writeToOutputPane("SOAP Messages saved to file : " + string5);
                }
                catch (IOException iOException) {
                    System.out.println("Exception : " + iOException.getMessage());
                    iOException.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(cursor);
        return bl;
    }

    public static ArrayList<String> parseLine2017(String string, char c, char c2) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null && string.isEmpty()) {
            return arrayList;
        }
        String string3 = String.valueOf(c);
        String string4 = String.valueOf(c2);
        int n = 0;
        int n2 = 0;
        n = string.indexOf(string3, n);
        while (n >= 0) {
            if (n2 <= n) {
                int n3;
                string2 = n - n2 > 0 ? string.substring(n2, n) : "";
                int n4 = n3 = string2.trim().startsWith(string4) ? string.indexOf(string4, n2) : -1;
                if (n3 >= 0) {
                    int n5 = string.indexOf(string4, n3 + 1);
                    if (n5 > n3) {
                        string2 = string.substring(n3, n5 + 1);
                        n = string.indexOf(string3, n5);
                    } else {
                        string2 = string.substring(n3);
                        n = -1;
                    }
                    arrayList.add(string2);
                } else {
                    arrayList.add(string2);
                }
            }
            if (n < 0) continue;
            n2 = n + 1;
            n = string.indexOf(string3, n2);
        }
        n = string.length() - 1;
        if (n2 < n && n - n2 > 0) {
            string2 = n - n2 > 0 ? string.substring(n2) : "";
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static ArrayList<String> parseLine(String string, char c, char c2) {
        char[] cArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null && string.isEmpty()) {
            return arrayList;
        }
        if (c2 == ' ') {
            c2 = (char)34;
        }
        if (c == ' ') {
            c = (char)44;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (char c3 : cArray = string.toCharArray()) {
            if (bl) {
                bl2 = true;
                if (c3 == c2) {
                    bl = false;
                    bl3 = false;
                    continue;
                }
                if (c3 == '\"') {
                    if (bl3) continue;
                    stringBuilder.append(c3);
                    bl3 = true;
                    continue;
                }
                stringBuilder.append(c3);
                continue;
            }
            if (c3 == c2) {
                bl = true;
                if (cArray[0] != '\"' && c2 == '\"') {
                    stringBuilder.append('\"');
                }
                if (!bl2) continue;
                stringBuilder.append('\"');
                continue;
            }
            if (c3 == c) {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                bl2 = false;
                continue;
            }
            if (c3 == '\r') continue;
            if (c3 == '\n') break;
            stringBuilder.append(c3);
        }
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    private static ArrayList<String> decodeCsvLine(String string, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || "".equals(string)) {
            return arrayList;
        }
        String string4 = "";
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        boolean bl4 = string.contains(string3);
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            bl2 = string2.equals(string5);
            bl3 = "".equals(string4);
            if (bl2 && bl3) {
                if (n > 0) {
                    bl = true;
                }
                ++n;
            } else {
                n = 0;
                string4 = string4 + string5;
                boolean bl5 = bl = !bl4 || !string4.startsWith(string3) || string4.endsWith(string3);
            }
            if (!bl) continue;
            if (string4.length() > 1 && string4.startsWith(string3) && string4.endsWith(string3)) {
                string4 = string4.substring(1, string4.length() - 1);
            }
            arrayList.add(string4);
            string4 = "";
            bl = false;
        }
        if (n > 0 && bl2 && bl3) {
            arrayList.add("");
        }
        return arrayList;
    }

    private static String[] decodeCSVLine(int n, String string, String string2) {
        ArrayList<String> arrayList = AbaEngineTest.decodeCsvLine(string, string2, "\"");
        if (n <= 0 && arrayList.size() > 0 || arrayList.size() == n) {
            return arrayList.toArray(new String[arrayList.size()]);
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            vector.add(string3);
        }
        String[] stringArray = vector.toArray(new String[0]);
        if (n > 0 && n != stringArray.length) {
            System.out.println("  ***  decodeCSVLine : comma separation correction for : " + string);
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (!stringArray[i].startsWith("\"") || stringArray[i].endsWith("\"")) continue;
                boolean bl = true;
                for (int j = i; j < stringArray.length - 1 && bl; ++j) {
                    int n2 = i;
                    stringArray[n2] = stringArray[n2] + ",";
                    int n3 = i;
                    stringArray[n3] = stringArray[n3] + stringArray[i + 1];
                    for (int k = i + 1; k < stringArray.length; ++k) {
                        stringArray[k] = k + 1 < stringArray.length ? stringArray[k + 1] : "";
                    }
                    bl = !stringArray[i].endsWith("\"");
                }
            }
        }
        return stringArray;
    }

    private static String[] decodeCSVLine_EmptyFieldProblem(int n, String string, String string2) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            vector.add(string3);
        }
        String[] stringArray = vector.toArray(new String[vector.size()]);
        if (n > 0 && n != stringArray.length) {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (!stringArray[i].startsWith("\"") || stringArray[i].endsWith("\"")) continue;
                boolean bl = true;
                for (int j = i; j < stringArray.length - 1 && bl; ++j) {
                    int n2 = i;
                    stringArray[n2] = stringArray[n2] + ",";
                    int n3 = i;
                    stringArray[n3] = stringArray[n3] + stringArray[i + 1];
                    for (int k = i + 1; k < stringArray.length; ++k) {
                        stringArray[k] = k + 1 < stringArray.length ? stringArray[k + 1] : "";
                    }
                    bl = !stringArray[i].endsWith("\"");
                }
            }
        }
        return stringArray;
    }

    private String getTimingReport(String string, long l, long l2, long l3) {
        String string2 = "";
        String string3 = "\n";
        double d = (double)(l2 - l) / 1000.0;
        string2 = string2 + string3;
        string2 = string2 + "Title : " + string;
        string2 = string2 + string3;
        string2 = string2 + "Start Time : " + ACUtilities.convertDateTimeToString(l);
        string2 = string2 + string3;
        string2 = string2 + "End Time   : " + ACUtilities.convertDateTimeToString(l2);
        string2 = string2 + string3;
        string2 = string2 + "Duration Total : " + String.format("%.2f", d) + " seconds";
        string2 = string2 + "  (";
        string2 = string2 + this.convertMillisecsToReadableDurationString(l2 - l);
        string2 = string2 + ")";
        string2 = string2 + string3;
        if (l3 > 0L) {
            string2 = string2 + "Number of Actions : " + l3;
            string2 = string2 + string3;
        }
        return string2;
    }

    private String convertMillisecsToReadableDurationString(long l) {
        String string = String.valueOf(l) + " ms";
        if (l >= 0L) {
            long l2 = (long)((double)l / 1000.0 / 60.0 / 60.0);
            long l3 = (long)((double)(l - l2 * 60L * 60L * 1000L) / 1000.0 / 60.0);
            long l4 = (long)((double)(l - l2 * 60L * 60L * 1000L - l3 * 60L * 1000L) / 1000.0);
            long l5 = l - l2 * 60L * 60L * 1000L - l3 * 60L * 1000L - l4 * 1000L;
            long l6 = l2 * 60L * 60L * 1000L + l3 * 60L * 1000L + l4 * 1000L + l5;
            StringBuilder stringBuilder = new StringBuilder();
            if (l2 > 0L) {
                stringBuilder.append(String.format("%d hrs ", l2));
            }
            if (l3 > 0L || stringBuilder.length() > 0) {
                stringBuilder.append(String.format("%d mins ", l3));
            }
            if (l4 > 0L || stringBuilder.length() > 0) {
                stringBuilder.append(String.format("%d secs ", l4));
            }
            if (l5 > 0L || stringBuilder.length() > 0) {
                stringBuilder.append(String.format("%d ms ", l5));
            }
            stringBuilder.append(String.format("(%d ms)", l));
            if (l6 != l) {
                stringBuilder.append(String.format("  !!! check calc Diff(%d - %d = %d)", l6, l, l6 - l));
            }
            string = stringBuilder.toString();
        } else {
            string = string + "  (negative)";
        }
        return string;
    }
}

