/*
 * ACUtilities.java  
 *
 * Creator:
 * 09.01.2008 13:48:11 Sippel
 *
 * Maintainer:
 * 09.01.2008 13:48:11 Sippel
 *
 * Last Modification:
 * $Id: $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */
package ch.abacus.testapp;

import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.GregorianCalendar;

public class ACUtilities {

    static SimpleDateFormat m_DateFormatter = new SimpleDateFormat("dd.MM.yyyy");
    static SimpleDateFormat m_DateTimeFormatter = new SimpleDateFormat("dd.MM.yyyy HH.mm:ss");

    static public String convertDateToString(Date date) {
        String formattedDate = "";
        if ( date == null ) return formattedDate;
        formattedDate = m_DateFormatter.format(date);
        return formattedDate;
    }

    static public String convertDateToTimeString(long timeInMilliseconds) {
        String formattedTime = "";
        if ( timeInMilliseconds <= 0 ) return formattedTime;
        formattedTime = convertDateToTimeString(new Date(timeInMilliseconds));
        return formattedTime;
    }

    static public String convertDateToTimeString(Date date) {
        String formattedTime = "";
        if ( date == null ) return formattedTime;
        formattedTime = m_DateTimeFormatter.format(date);
        if ( !StringIsNullOrEmpty(formattedTime) ) {
            if ( formattedTime.length() > 12 ) {
                formattedTime = formattedTime.substring(11);
            } else {
                formattedTime = "";
            }
        }
        return formattedTime;
    }

    static public String convertDateToString(long timeInMilliseconds) {
        String formattedDate = "";
        if ( timeInMilliseconds <= 0 ) return formattedDate;
        formattedDate = convertDateToString(new Date(timeInMilliseconds));
        return formattedDate;
    }

    static public boolean StringIsNullOrEmpty(String text) {
        return( text == null || "".equals(text) );
    }

    static public String convertDateTimeToString(long timeInMilliseconds) {
        String formattedDate = "";
        if ( timeInMilliseconds <= 0 ) return formattedDate;
        formattedDate = convertDateTimeToString(new Date(timeInMilliseconds));
        return formattedDate;
    }

    static public String convertDateTimeToString(Date date) {
        String formattedDate = "";
        if ( date == null ) return formattedDate;
        formattedDate = m_DateTimeFormatter.format(date);
        return formattedDate;
    }

    static public BigDecimal convertDoubleToBigDecimal(double number) {
        return convertDoubleToBigDecimal(number, -1 );
    }

    static public BigDecimal convertDoubleToBigDecimal(double number, int decimalPlaces ) {
        String sVal = String.valueOf(number);
//        if ( sVal.indexOf(".") > 0 ) sVal += "00";
        return new BigDecimal(sVal);
    }

    static public String getCurrentUserWorkingDirectory() {
        return System.getProperty("user.dir");
    }

    static public String getOperatingSystemLineSeparator() {
        return System.getProperty("line.separator");
    }

    static public String getOperatingSystemName() {
        return System.getProperty("os.name");
    }

    static public boolean isLinuxOperatingSystem() {
        String operatingSystemName = getOperatingSystemName();
        if ( StringIsNullOrEmpty(operatingSystemName) ) return false;
        if ( operatingSystemName.toLowerCase().contains("linux") ) return true;
        return false;
    }

    static public long convertTextToLong(String text, long defaultValue)
    {
        long val;
        try
        {
            val = Long.parseLong(text);
        }
        catch (NumberFormatException nfe)
        {
            val = defaultValue;
        }
        return val;
    }


    /**
     * Read a version string from a resource Text file.  Used for display in the Title
     * bar of some applications.
     *
     * If resource file is not found then just returns the hardcoded version string.
     *
     * @return returns a version string e.g. "V14.05"
     */
    public static String getCurrentProgramVersionInfo() {

        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(System.currentTimeMillis());
        int currentYear = gc.get(Calendar.YEAR);

        String prefix = " : JA-V";
        String versionText = prefix + String.valueOf(currentYear - 2001) + ".12-0";
        String versionFilename = "version.txt";
        URL versionUrl = ACUtilities.class.getResource(versionFilename);
        InputStream versionInputStream = null;
        if ( versionUrl != null ) {
            try {
                versionInputStream = versionUrl.openStream();
                int count;
                int bufferSize = 256;
                byte data[] = new byte[bufferSize];
                while ((count = versionInputStream.read(data, 0, bufferSize)) != -1) {
                    String value = new String(data,0,count);
                    if ( !StringIsNullOrEmpty(value) ) {
                        int iPos = value.indexOf("\n");
                        if ( iPos > 0 ) {
                            value = value.substring(0, iPos).trim();
                        }
                        iPos = value.indexOf("\r");
                        if ( iPos > 0 ) {
                            value = value.substring(0, iPos).trim();
                        }
                        iPos = value.indexOf(".");
                        if ( iPos == 4 ) {
                            versionText = prefix + value.substring(2).trim();
                        } else if ( iPos > 0 ) {
                            versionText = prefix + value.trim();
                        }
                    }
                }
                versionInputStream.close();
            } catch ( Exception ce ) {
                ce.printStackTrace();
                return versionText; // Version cannot be loaded
            }
        }
        return versionText;
    }

}
