echo off
REM Batchfile to create an AbaConnect Webservice
REM ********************************************

rem The following line is needed for the loop count RESULT_FILE_COUNT
setlocal enableextensions enabledelayedexpansion

rem --- Sets the sub-directory for the output client code ---
set OUTPUT_SUBDIR=generatedClient_axis1

rem --- Sets the root path for axis1 jars ---
rem --- The axis1 jars should be found in the sub directory %JAVA_JARS% ---
rem
set JAVA_JARS=..\jars

rem --- Check for some jars to see if the axis path is set correctly ---
rem if NOT EXIST "%JAVA_JARS%\activation-1.1.jar" goto missing_activation_jars
if NOT EXIST "%JAVA_JARS%\axis.jar" goto missing_jars

rem --- remove and create output sub-directory to delete contents ---
if EXIST %OUTPUT_SUBDIR% (
   echo.
   echo Removing existing output folder : %OUTPUT_SUBDIR%
   rmdir /S /Q %OUTPUT_SUBDIR%
)
if NOT EXIST %OUTPUT_SUBDIR% md %OUTPUT_SUBDIR%

REM Set the classpath for axis jar files
REM ***********
echo off
set CLASSPATH=%cp%
set cp=%CLASSPATH%
rem Apache Axis Jars 
rem =======================
set CLASSPATH=%CLASSPATH%;%JAVA_JARS%\axis.jar
set CLASSPATH=%CLASSPATH%;%JAVA_JARS%\commons-discovery-0.2.jar
set CLASSPATH=%CLASSPATH%;%JAVA_JARS%\commons-logging-1.0.4.jar
set CLASSPATH=%CLASSPATH%;%JAVA_JARS%\jaxrpc.jar
set CLASSPATH=%CLASSPATH%;%JAVA_JARS%\saaj.jar
set CLASSPATH=%CLASSPATH%;%JAVA_JARS%\wsdl4j-1.5.1.jar
set CLASSPATH=%CLASSPATH%;%JAVA_JARS%\wss4j.jar
set CLASSPATH=%CLASSPATH%;%JAVA_JARS%\xml-apis.jar


set CLASSPATH=%CLASSPATH%;%JAVA_JARS%\extra\activation-1.1.jar
set CLASSPATH=%CLASSPATH%;%JAVA_JARS%\extra\mail-1.4.jar

rem ---- Name of the WSDL file without extension ----
set WSDL_ID_NAME=abaengine
rem ---- Same as abouve but all lower case ----
set PACKAGE_ID_NAME=abaengine

rem ---- Name of the application used for packages ----
set APPLICATION_PACKAGE=abaengine

rem ---- Name of the WSDL file ----
set WSDL_SOURCE_FILE=%WSDL_ID_NAME%.wsdl
if NOT EXIST "%WSDL_SOURCE_FILE%" (
    set WSDL_SOURCE_FILE=http://localhost:40000/.abaengine?wsdl
)

rem ---- Root Package created under the output Path ----
set ROOT_PACKAGE=AbaEngine_pkg


set MAIN_PACKAGE=%ROOT_PACKAGE%
set MAIN_PACKAGE=ch.abacus.ws.%APPLICATION_PACKAGE%

echo.

set COMMAND_LINE=java org.apache.axis.wsdl.WSDL2Java -o "%OUTPUT_SUBDIR%" -p %MAIN_PACKAGE% %WSDL_SOURCE_FILE%
rem Display the command-line in DOS window before executing
echo Executing command-line :
echo %COMMAND_LINE%
rem Execute the command-line
%COMMAND_LINE%

echo.
rem Look for resulting AbaEngine.java file
set /A RESULT_FILE_COUNT=0
for /R %OUTPUT_SUBDIR% %%f in (*.java) do (
   rem echo.
   rem echo    :--  "%%f" 
   if EXIST "%%f" set /A RESULT_FILE_COUNT=!RESULT_FILE_COUNT! + 1
)
echo Resulting generated java file count is [%RESULT_FILE_COUNT%]
if "%RESULT_FILE_COUNT%"=="0" (
    echo.
    echo ***** ERRORS OCCURRED ***************************************
    echo The generated source code could not be created from the WSDL
    echo     NO SOURCE CODE FILES CREATED
    echo.
) else (
    echo The source code was generated from the WSDL
)
goto end
:missing_activation_jars
echo.
echo ***** ERRORS OCCURRED ***************************************
echo The required activation.jar could not be found in set path.
echo     Check path %JAVA_JARS% (could not find %JAVA_JARS%\activation-1.1.jar)
echo.
goto end

:missing_jars
echo.
echo ***** ERRORS OCCURRED ***************************************
echo The required jars could not be found in set path.
echo     Check path %JAVA_JARS% and %JAVA_JARS%
echo.

:end
rem --- Set the classpath back to the original ---
set CLASSPATH=%cp%

echo.
echo.
pause



