/*
 * LoginDialog.java  
 *
 * Creator:
 * 13.07.2007 14:41:20 Sippel
 *
 * Maintainer:
 * 13.07.2007 14:41:20 Sippel
 *
 * Last Modification:
 * $Id: $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */
package ch.abacus.testapp;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class LoginDialog extends JDialog {

    private JTextField m_txfUsername;
    private JPasswordField m_txfPassword;
    private JTextField m_txfMandant;

   private boolean m_DialogEndedWithOK = false;
    private String mUsername = "Administrator";
    private String mPassword = "eli";
    private int mMandant = 7777;

    private ActionListener mOkButtonActionListener = null;
    private ActionListener mCancelButtonActionListener = null;

    public LoginDialog(Frame owner) throws HeadlessException {
        super(owner);
        initUI();
    }

    private void initUI() {
        Container dlgPane = this.getContentPane();
        if ( dlgPane == null ) return;
        JPanel mainPanel = UiComponentHelper.getPanelWithBoxLayout(BoxLayout.PAGE_AXIS,-1,-1);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
        mainPanel.setLayout(new BoxLayout(mainPanel,BoxLayout.PAGE_AXIS));

        JPanel line = UiComponentHelper.getLinePanel(20);

        JLabel lblUserName = UiComponentHelper.getLabel("Username : ", 110);
        m_txfUsername = UiComponentHelper.getTextField(mUsername, -1);
        line.add(lblUserName);
        line.add(m_txfUsername);
        mainPanel.add(line);

        line = UiComponentHelper.getLinePanel(20);
        JLabel lblPassword = UiComponentHelper.getLabel("Password : ", 110);
        m_txfPassword = new JPasswordField(mPassword);
        line.add(lblPassword);
        line.add(m_txfPassword);
        mainPanel.add(Box.createVerticalStrut(5));
        mainPanel.add(line);

        line = UiComponentHelper.getLinePanel(20);
        JLabel lblMandant = UiComponentHelper.getLabel("Mandant : ", 110);
        m_txfMandant = UiComponentHelper.getTextField(String.valueOf(mMandant), -1);
        line.add(lblMandant);
        line.add(m_txfMandant);
        mainPanel.add(Box.createVerticalStrut(5));
        mainPanel.add(line);

        line = UiComponentHelper.getLinePanel(20);
        JButton btnOk = UiComponentHelper.getButton("OK", 100);
        JButton btnCancel = UiComponentHelper.getButton("Cancel", 100);
        line.add(UiComponentHelper.getHorizontalSpacer());
        line.add(btnOk);
        line.add(Box.createHorizontalStrut(5));
        line.add(btnCancel);
        mainPanel.add(Box.createVerticalStrut(5));
        mainPanel.add(line);

        btnOk.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                updateValuesFromDialog();
                m_DialogEndedWithOK = true;
                if ( mOkButtonActionListener != null ) {
                    mOkButtonActionListener.actionPerformed(e);
                }
                setVisible(false);
                dispose();
            }
        });

        btnCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if ( mCancelButtonActionListener != null ) {
                    mCancelButtonActionListener.actionPerformed(e);
                }
                setVisible(false);
                dispose();
            }
        });

        dlgPane.add(mainPanel);
        setSize(300, 150);
//        setLocation(200, 200);
        setTitle("AbaEngine Login");
        m_DialogEndedWithOK = false;
    }

    public void setButtonActionListeners( ActionListener actionButtonOK, ActionListener actionButtonCancel ) {
        mOkButtonActionListener = actionButtonOK;
        mCancelButtonActionListener = actionButtonCancel;
    }

    private void updateValuesFromDialog() {
        mUsername = (m_txfUsername == null ? "Administrator" : m_txfUsername.getText());
        mPassword = (m_txfPassword == null ? "eli" : String.valueOf(m_txfPassword.getPassword()));
        int mandant = 7777;
        if ( m_txfMandant != null ) {
            try {
                mandant = Integer.parseInt(m_txfMandant.getText());
            } catch( NumberFormatException nfe ) {
                mandant = 7777;
            }
        }
        mMandant = mandant;
    }

    public String getUserName() {
        return mUsername;
    }

    public String getPassword() {
        return mPassword;
    }

    public int getMandant() {
        return mMandant;
    }

    public void setUserName(String username) {
        mUsername = username;
        if ( m_txfUsername != null ) m_txfUsername.setText(mUsername);
    }

    public void setPassword(String password) {
        mPassword = password;
        if ( m_txfPassword != null ) m_txfPassword.setText(mPassword);
    }

    public void setMandant(int mandant) {
        mMandant = mandant;
        if ( m_txfMandant != null ) m_txfMandant.setText(String.valueOf(mMandant));
    }

    public boolean isDialogEndedWithOK() {
        return m_DialogEndedWithOK;
    }
}
