/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.trust.message.token;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.WSEncryptBody;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.x509.XMLX509IssuerSerial;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class RequestedProofToken {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$trust$message$token$RequestedProofToken == null ? (class$org$apache$ws$security$trust$message$token$RequestedProofToken = RequestedProofToken.class$("org.apache.ws.security.trust.message.token.RequestedProofToken")) : class$org$apache$ws$security$trust$message$token$RequestedProofToken).getName());
    public static final QName TOKEN = new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "RequestedProofToken");
    private Element element;
    private byte[] sharedSecret;
    static /* synthetic */ Class class$org$apache$ws$security$trust$message$token$RequestedProofToken;

    public RequestedProofToken(Document doc) throws WSSecurityException {
        this.element = doc.createElementNS("http://schemas.xmlsoap.org/ws/2005/02/trust", "wst:" + TOKEN.getLocalPart());
        WSSecurityUtil.setNamespace(this.element, TOKEN.getNamespaceURI(), "wst");
        this.element.appendChild(doc.createTextNode(""));
        log.debug((Object)"RequestedProofToken : Document constructor, Element created.");
    }

    public RequestedProofToken(Element elem) throws WSSecurityException {
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN)) {
            throw new WSSecurityException(4, "badTokenType00", new Object[]{el});
        }
        log.debug((Object)"RequestedProofToken :: Element constructor, Element created.");
    }

    public void doDecryption(String callback, Crypto crypto) throws WSSecurityException {
        CallbackHandler cbHandler;
        WSSecurityEngine secEngine = new WSSecurityEngine();
        NodeList ndList = this.element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
        if (ndList.getLength() < 1) {
            throw new WSSecurityException(7, "RequestedProofToken is empty");
        }
        if (callback != null) {
            Class<?> cbClass = null;
            try {
                cbClass = Class.forName(callback);
            }
            catch (ClassNotFoundException e) {
                throw new WSSecurityException(8, "RequestedProofToken: cannot load password callback class: " + callback);
            }
            try {
                cbHandler = (CallbackHandler)cbClass.newInstance();
            }
            catch (Exception e) {
                throw new WSSecurityException(8, "RequestedProofToken: cannot create instance of password callback: " + callback + ":: ErrMsg " + e.getMessage());
            }
        }
        log.debug((Object)"RequestedProofToken :: CallbackHandler is null");
        throw new WSSecurityException(0, "CallbackHandler is null");
        secEngine.handleEncryptedKey((Element)ndList.item(0), cbHandler, crypto);
        this.sharedSecret = secEngine.getDecryptedBytes();
        log.debug((Object)(" RequestedProofToken, decryption ,Shared secret is :: " + new String(this.sharedSecret)));
        log.debug((Object)"RequestedProofToken :: Encryption done");
    }

    public void doEncryptProof(Document doc, Crypto crypto, String userInfo) throws WSSecurityException {
        WSEncryptBody wsEncrypt = new WSEncryptBody();
        try {
            wsEncrypt.setUserInfo(userInfo);
            wsEncrypt.setKeyIdentifierType(1);
            wsEncrypt.setParentNode(this.element);
            if (this.sharedSecret != null) {
                // empty if block
            }
            wsEncrypt.build(doc, crypto);
            this.sharedSecret = wsEncrypt.getEncryptionKey().getEncoded();
        }
        catch (WSSecurityException e) {
            e.printStackTrace();
        }
        log.debug((Object)"RequestedProofToken :: Decryption Done");
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public void addToken(Element childToken) {
        this.element.appendChild(childToken);
    }

    public void removeToken(Element childToken) {
        this.element.removeChild(childToken);
    }

    public byte[] getSharedSecret() {
        return this.sharedSecret;
    }

    public void setSharedSecret(byte[] bs) {
        this.sharedSecret = bs;
    }

    public Document build(Document doc, Crypto crypto, String user, Element parentNode) throws WSSecurityException {
        boolean doDebug = log.isDebugEnabled();
        int keyIdentifierType = 2;
        SecretKey symmetricKey = null;
        String symEncAlgo = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
        String keyEncAlgo = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
        if (doDebug) {
            log.debug((Object)"Beginning Encryption...");
        }
        Element envelope = doc.getDocumentElement();
        envelope.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xenc", "http://www.w3.org/2001/04/xmlenc#");
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(envelope);
        KeyGenerator keyGen = null;
        try {
            keyGen = KeyGenerator.getInstance("DESede");
        }
        catch (NoSuchAlgorithmException e2) {
            e2.printStackTrace();
        }
        symmetricKey = keyGen.generateKey();
        XMLCipher xmlCipher = null;
        try {
            xmlCipher = XMLCipher.getInstance((String)symEncAlgo);
        }
        catch (XMLEncryptionException e3) {
            throw new WSSecurityException(2, null, null, e3);
        }
        X509Certificate remoteCert = null;
        X509Certificate[] certs = crypto.getCertificates(user);
        if (certs == null || certs.length <= 0) {
            throw new WSSecurityException(0, "invalidX509Data", new Object[]{"for Encryption"});
        }
        remoteCert = certs[0];
        String certUri = "EncCertId-" + remoteCert.hashCode();
        Cipher cipher = null;
        try {
            cipher.init(1, remoteCert);
        }
        catch (InvalidKeyException e) {
            throw new WSSecurityException(8, null, null, e);
        }
        byte[] encKey = symmetricKey.getEncoded();
        if (doDebug) {
            log.debug((Object)("cipher blksize: " + cipher.getBlockSize() + ", symm key length: " + encKey.length));
        }
        if (cipher.getBlockSize() < encKey.length) {
            throw new WSSecurityException(0, "unsupportedKeyTransp", new Object[]{"public key algorithm too weak to encrypt symmetric key"});
        }
        byte[] encryptedKey = null;
        try {
            encryptedKey = cipher.doFinal(encKey);
        }
        catch (IllegalStateException e1) {
            throw new WSSecurityException(8, null, null, e1);
        }
        catch (IllegalBlockSizeException e1) {
            throw new WSSecurityException(8, null, null, e1);
        }
        catch (BadPaddingException e1) {
            throw new WSSecurityException(8, null, null, e1);
        }
        Text keyText = WSSecurityUtil.createBase64EncodedTextNode(doc, encryptedKey);
        Element xencEncryptedKey = WSEncryptBody.createEnrcyptedKey(doc, keyEncAlgo);
        WSSecurityUtil.prependChildElement(doc, parentNode, xencEncryptedKey, true);
        SecurityTokenReference secToken = null;
        switch (keyIdentifierType) {
            case 3: {
                secToken.setKeyIdentifier(remoteCert);
                break;
            }
            case 4: {
                secToken.setKeyIdentifierSKI(remoteCert, crypto);
                break;
            }
            case 2: {
                secToken.setX509IssuerSerial(new XMLX509IssuerSerial(doc, remoteCert));
                WSSecurityUtil.setNamespace(secToken.getElement(), WSConstants.WSSE_NS, "wsse");
                break;
            }
            case 1: {
                X509Security bstToken = null;
                bstToken = new X509Security(WSSConfig.getDefaultWSConfig(), doc);
                bstToken.setX509Certificate(remoteCert);
                bstToken.setID(certUri);
                Reference ref = new Reference(WSSConfig.getDefaultWSConfig(), doc);
                ref.setURI("#" + certUri);
                ref.setValueType(bstToken.getValueType());
                secToken.setReference(ref);
                break;
            }
            default: {
                throw new WSSecurityException(0, "unsupportedKeyId");
            }
        }
        KeyInfo keyInfo = new KeyInfo(doc);
        keyInfo.addUnknownElement(secToken.getElement());
        WSSecurityUtil.appendChildElement(doc, xencEncryptedKey, keyInfo.getElement());
        Element xencCipherValue = WSEncryptBody.createCipherValue(doc, xencEncryptedKey);
        xencCipherValue.appendChild(keyText);
        log.debug((Object)"Encryption complete.");
        return doc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

