/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.trust.message.token;

import javax.xml.namespace.QName;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.trust.WSTrustException;
import org.apache.ws.security.trust.message.token.CompositeElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RenewTarget
extends CompositeElement {
    public static final QName TOKEN = new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "RenewTarget", "wst");
    private Element tokenToBeRenewed;
    private SecurityTokenReference securityTokenReference;

    public RenewTarget(Element elem) throws WSTrustException {
        super(elem);
    }

    public RenewTarget(Document doc) {
        super(doc);
    }

    public SecurityTokenReference getSecurityTokenReference() {
        return this.securityTokenReference;
    }

    public void setSecurityTokenReference(SecurityTokenReference securityTokenReference) {
        if (this.tokenToBeRenewed != null) {
            this.element.removeChild(this.tokenToBeRenewed);
        }
        if (this.securityTokenReference != null) {
            this.element.removeChild(this.securityTokenReference.getElement());
        }
        this.securityTokenReference = securityTokenReference;
        this.element.appendChild(this.securityTokenReference.getElement());
    }

    public Element getTokenToBeRenewed() {
        return this.tokenToBeRenewed;
    }

    public void setTokenToBeRenewed(Element tokenToBeRenewed) {
        if (this.securityTokenReference != null) {
            this.element.removeChild(this.securityTokenReference.getElement());
        }
        if (this.tokenToBeRenewed != null) {
            this.element.removeChild(this.tokenToBeRenewed);
        }
        this.tokenToBeRenewed = tokenToBeRenewed;
        this.element.appendChild(this.tokenToBeRenewed);
    }

    protected QName getToken() {
        return TOKEN;
    }

    protected void deserializeChildElement(Element elem) throws WSTrustException {
        QName secTokRef;
        QName el = new QName(elem.getNamespaceURI(), elem.getLocalName());
        if (el.equals(secTokRef = new QName(WSConstants.WSSE_NS, "SecurityTokenReference"))) {
            try {
                this.securityTokenReference = new SecurityTokenReference(WSSConfig.getDefaultWSConfig(), elem);
            }
            catch (WSSecurityException ex) {
                throw new WSTrustException("InvalidRequest", ex.getMessage());
            }
        } else {
            this.tokenToBeRenewed = elem;
        }
    }
}

