/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.trust.message.token;

import javax.xml.namespace.QName;
import org.apache.ws.security.policy.message.token.AppliesTo;
import org.apache.ws.security.trust.WSTrustException;
import org.apache.ws.security.trust.message.token.Claims;
import org.apache.ws.security.trust.message.token.Entropy;
import org.apache.ws.security.trust.message.token.KeySize;
import org.apache.ws.security.trust.message.token.Lifetime;
import org.apache.ws.security.trust.message.token.Renewing;
import org.apache.ws.security.trust.message.token.RequestSecurityToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IssueRequestSecurityToken
extends RequestSecurityToken {
    private AppliesTo appliesToElement;
    private Claims claimsElement;
    private Entropy entropyElement;
    private Lifetime lifetimeElement;
    private KeySize keySizeElement;
    private Renewing renewingElement;

    public IssueRequestSecurityToken(Document doc) {
        super(doc, "http://schemas.xmlsoap.org/ws/2005/02/trust/Issue");
    }

    public IssueRequestSecurityToken(Element elem) throws WSTrustException {
        super(elem);
    }

    public void setAppliesTo(String appliesTo) {
        if (this.appliesToElement == null) {
            this.appliesToElement = new AppliesTo(this.element.getOwnerDocument());
            this.element.appendChild(this.appliesToElement.getElement());
        }
        this.appliesToElement.setEndpointReference(appliesTo);
    }

    public void setEntropy(String binarySecretType, String entropyValue) {
        if (this.entropyElement == null) {
            this.entropyElement = new Entropy(this.document);
            this.addChild(this.entropyElement);
        }
        this.entropyElement.setBinarySecret(binarySecretType, entropyValue);
    }

    public void setEntropyNonce(String nonceValue) {
        this.setEntropy("http://schemas.xmlsoap.org/ws/2005/02/trust/Nonce", nonceValue);
    }

    public void setLifetime(int duration) {
        if (this.lifetimeElement == null) {
            this.removeChild(this.lifetimeElement);
        }
        this.lifetimeElement = new Lifetime(this.document, duration);
    }

    public void setKeySize(int size) {
        if (this.keySizeElement == null) {
            this.keySizeElement = new KeySize(this.document);
            this.addChild(this.keySizeElement);
        }
        this.keySizeElement.setKeySize(size);
    }

    public void setClaims(String dialectURI, Element claimsElement) {
        if (this.claimsElement == null) {
            this.claimsElement = new Claims(this.document);
            this.addChild(this.claimsElement);
        }
        this.claimsElement.setDialectAttribute(dialectURI);
        this.claimsElement.addToken(claimsElement);
    }

    public void setClaims(String dialectURI, NodeList claims) {
        if (this.claimsElement == null) {
            this.claimsElement = new Claims(this.document);
            this.addChild(this.claimsElement);
        }
        this.claimsElement.setDialectAttribute(dialectURI);
        this.claimsElement.addClaims(claims);
    }

    public void setClaimsDialectAttr(String dialectURI) {
        if (this.claimsElement == null) {
            this.claimsElement = new Claims(this.document);
            this.addChild(this.claimsElement);
        }
        this.claimsElement.setDialectAttribute(dialectURI);
    }

    public void setRenewing(boolean allow, boolean ok) {
        if (this.renewingElement == null) {
            this.renewingElement = new Renewing(this.document);
            this.addChild(this.renewingElement);
        }
        this.renewingElement.setAllow(allow);
        this.renewingElement.setOK(ok);
    }

    public AppliesTo getAppliesToElement() {
        return this.appliesToElement;
    }

    public Claims getClaimsElement() {
        return this.claimsElement;
    }

    public Entropy getEntropyElement() {
        return this.entropyElement;
    }

    public KeySize getKeySizeElement() {
        return this.keySizeElement;
    }

    public Lifetime getLifetimeElement() {
        return this.lifetimeElement;
    }

    public Renewing getRenewingElement() {
        return this.renewingElement;
    }

    protected void handleSpecificChildren(Element elem) throws WSTrustException {
        QName el = new QName(elem.getNamespaceURI(), elem.getLocalName());
        if (el.equals(AppliesTo.TOKEN)) {
            this.appliesToElement = new AppliesTo(elem);
        } else if (el.equals(Claims.TOKEN)) {
            this.claimsElement = new Claims(elem);
        } else if (el.equals(Entropy.TOKEN)) {
            this.entropyElement = new Entropy(elem);
        } else if (el.equals(Lifetime.TOKEN)) {
            this.lifetimeElement = new Lifetime(elem);
        } else if (el.equals(KeySize.TOKEN)) {
            this.keySizeElement = new KeySize(elem);
        } else if (el.equals(Renewing.TOKEN)) {
            this.renewingElement = new Renewing(elem);
        } else {
            throw new WSTrustException("InvalidRequest", "incorrectChildElement", new Object[]{TOKEN.getPrefix(), TOKEN.getLocalPart(), el.getNamespaceURI(), el.getLocalPart()});
        }
    }
}

