/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.trust.message.token;

import javax.xml.namespace.QName;
import org.apache.ws.security.trust.WSTrustException;
import org.apache.ws.security.util.DOM2Writer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class AbstractToken {
    protected Element element;
    protected Document document;

    protected abstract QName getToken();

    public AbstractToken(Document doc) {
        QName token = this.getToken();
        this.element = doc.createElementNS(token.getNamespaceURI(), "wst:" + token.getLocalPart());
        this.document = doc;
    }

    public AbstractToken(Element elem) throws WSTrustException {
        QName token = this.getToken();
        QName el = new QName(elem.getNamespaceURI(), elem.getLocalName());
        if (!el.equals(token)) {
            throw new WSTrustException("InvalidRequest", "badTokenType", new Object[]{el});
        }
        this.element = elem;
        this.document = elem.getOwnerDocument();
        this.parse(this.element);
    }

    public void parse(Element elem) throws WSTrustException {
        NodeList nodeList = elem.getChildNodes();
        block4: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node tempNode = nodeList.item(i);
            switch (tempNode.getNodeType()) {
                case 1: {
                    this.deserializeChildElement((Element)tempNode);
                    continue block4;
                }
                case 3: {
                    this.setElementTextValue((Text)tempNode);
                }
            }
        }
    }

    protected abstract void deserializeChildElement(Element var1) throws WSTrustException;

    protected abstract void setElementTextValue(Text var1) throws WSTrustException;

    protected Element getElement() {
        return this.element;
    }

    protected void setElement(Element element) {
        this.element = element;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    protected void addChild(AbstractToken token) {
        this.element.appendChild(token.getElement());
    }

    protected void removeChild(AbstractToken token) {
        this.element.removeChild(token.getElement());
    }
}

