/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.axis.security.trust.service;

import java.io.OutputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.ByteArrayOutputStream;
import org.apache.ws.axis.security.trust.service.RequestSecurityTokenType;
import org.apache.ws.security.trust.STSManager;
import org.apache.ws.security.util.Loader;
import org.apache.xml.security.Init;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SecurityTokenService {
    protected Hashtable options;

    public SecurityTokenService() {
        this.loadProperties("STS.properties");
    }

    public void requestSecurityToken(RequestSecurityTokenType request) throws RemoteException {
        try {
            MessageContext msgCntxt = MessageContext.getCurrentContext();
            msgCntxt.getRequestMessage();
            Object sHeader = null;
            Message smReq = msgCntxt.getRequestMessage();
            Message smCurr = msgCntxt.getResponseMessage();
            SOAPPart sPartReq = (SOAPPart)smReq.getSOAPPart();
            SOAPPart sPartRes = (SOAPPart)smCurr.getSOAPPart();
            Document docRes = null;
            try {
                Init.init();
                Document docReq = ((SOAPEnvelope)sPartReq.getEnvelope()).getAsDocument();
                docRes = ((SOAPEnvelope)sPartRes.getEnvelope()).getAsDocument();
                STSManager stsMgr = new STSManager(this.options);
                docRes = stsMgr.handleRequest(docReq, docRes);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                XMLUtils.outputDOM((Node)docRes, (OutputStream)os, (boolean)true);
                sPartRes.setCurrentMessage((Object)os.toByteArray(), 4);
                msgCntxt.setCurrentMessage(sPartRes.getMessage());
            }
            catch (Exception ex) {
                throw new AxisFault("STSServerHandler-dorequest:Response failed due to a problem in issuence process", (Throwable)ex);
            }
        }
        catch (Exception e) {
            System.out.println("Exception is " + e.getMessage());
            throw new AxisFault();
        }
    }

    protected void loadProperties(String propFilename) {
        Properties properties = new Properties();
        try {
            URL url = Loader.getResource(propFilename);
            properties.load(url.openStream());
        }
        catch (Exception e) {
            throw new RuntimeException("SecurityTokenSErvice: Cannot load properties: " + propFilename);
        }
        this.options = new Hashtable();
        Enumeration<Object> enumKeys = properties.keys();
        while (enumKeys.hasMoreElements()) {
            String key = (String)enumKeys.nextElement();
            this.options.put(key, properties.getProperty(key));
        }
    }
}

