/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.xmltools;

import ch.abacus.xmltools.TestSaxParser;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class XmlFormatter
extends TestSaxParser {
    private boolean mStripWhitespaces = false;
    private String mLineFeed = "\n";
    private String mIndent = "  ";
    private String mLastStartElementName = "";
    private StringBuffer mFormattedXml = new StringBuffer();
    ArrayList<String> mElementNames = new ArrayList();
    private boolean mRemoveNamespacePrefixes = true;

    @Override
    public void startDocument() {
        super.startDocument();
        this.mFormattedXml.setLength(0);
    }

    public boolean isRemoveNamespacePrefixes() {
        return this.mRemoveNamespacePrefixes;
    }

    public void setRemoveNamespacePrefixes(boolean bl) {
        this.mRemoveNamespacePrefixes = bl;
    }

    public boolean isStripWhitespaces() {
        return this.mStripWhitespaces;
    }

    public void setStripWhitespaces(boolean bl) {
        this.mStripWhitespaces = bl;
    }

    public void setIndent(String string) {
        this.mIndent = string == null ? "" : string;
    }

    public void setLineFeed(String string) {
        this.mLineFeed = string == null ? "" : string;
    }

    @Override
    public void endElement(String string, String string2) {
        this.mElementNames.remove(string);
        if (string.equals(this.mLastStartElementName)) {
            this.mLastStartElementName = "";
        } else {
            this.mFormattedXml.append(this.mLineFeed);
            int n = this.mElementNames.size();
            for (int i = 0; i < n; ++i) {
                this.mFormattedXml.append(this.mIndent);
            }
        }
        if (!this.mStripWhitespaces || !this.isValueBlankLine(string2)) {
            this.mFormattedXml.append(this.escapeXMLText(string2));
        }
        this.mFormattedXml.append("</");
        if (this.mRemoveNamespacePrefixes) {
            this.mFormattedXml.append(this.removeNamespacePrefix(string));
        } else {
            this.mFormattedXml.append(string);
        }
        this.mFormattedXml.append(">");
    }

    @Override
    public void startElement(String string, Attributes attributes) {
        int n;
        int n2;
        if (this.mStripWhitespaces) {
            this.elementValue.reset();
        }
        if ((n2 = this.mElementNames.size()) > 0) {
            this.mFormattedXml.append(this.mLineFeed);
        }
        for (n = 0; n < n2; ++n) {
            this.mFormattedXml.append(this.mIndent);
        }
        this.mElementNames.add(string);
        this.mFormattedXml.append("<");
        if (this.mRemoveNamespacePrefixes) {
            this.mFormattedXml.append(this.removeNamespacePrefix(string));
        } else {
            this.mFormattedXml.append(string);
        }
        if (attributes != null && (n = attributes.getLength()) > 0) {
            for (int i = 0; i < n; ++i) {
                this.mFormattedXml.append(" ");
                this.mFormattedXml.append(attributes.getLocalName(i));
                this.mFormattedXml.append("=");
                this.mFormattedXml.append("\"");
                this.mFormattedXml.append(attributes.getValue(i));
                this.mFormattedXml.append("\"");
            }
        }
        this.mFormattedXml.append(">");
        this.mLastStartElementName = string;
    }

    public String getFormattedXml() {
        return this.mFormattedXml.toString();
    }

    private String removeNamespacePrefix(String string) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf(":");
        return n >= 0 ? string.substring(n + 1) : string;
    }

    private String escapeXMLText(String string) {
        String string2 = "&lt;";
        String string3 = "&gt;";
        String string4 = "&quot;";
        String string5 = "&amp;";
        String string6 = "&apos;";
        String string7 = "&#x";
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder(string);
        block7: while (n < stringBuilder.length()) {
            char c = stringBuilder.charAt(n);
            if (c >= ' ' && Character.isDefined(c)) {
                switch (c) {
                    case '\"': {
                        stringBuilder.deleteCharAt(n);
                        stringBuilder.insert(n, string4);
                        n += string4.length();
                        continue block7;
                    }
                    case '&': {
                        String string8;
                        int n2 = stringBuilder.length();
                        int n3 = n + 10;
                        String string9 = string8 = n3 >= n2 ? stringBuilder.substring(n) : stringBuilder.substring(n, n + 10);
                        if (!(string8.startsWith(string5) || string8.startsWith(string2) || string8.startsWith(string3) || string8.startsWith(string4) || string8.startsWith(string6) || string8.startsWith(string7))) {
                            stringBuilder.deleteCharAt(n);
                            stringBuilder.insert(n, string5);
                            n += string5.length();
                            continue block7;
                        }
                        ++n;
                        continue block7;
                    }
                    case '\'': {
                        stringBuilder.deleteCharAt(n);
                        stringBuilder.insert(n, string6);
                        n += string6.length();
                        continue block7;
                    }
                    case '<': {
                        stringBuilder.deleteCharAt(n);
                        stringBuilder.insert(n, string2);
                        n += string2.length();
                        continue block7;
                    }
                    case '>': {
                        stringBuilder.deleteCharAt(n);
                        stringBuilder.insert(n, string3);
                        n += string3.length();
                        continue block7;
                    }
                }
                ++n;
                continue;
            }
            ++n;
        }
        return stringBuilder.toString();
    }
}

