/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.testapp;

import ch.abacus.testapp.ACUtilities;
import ch.abacus.testapp.AbaViewReportType;
import ch.abacus.testapp.UiComponentHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StandardExampleFrame
extends JFrame {
    private static String EXAMPLE_CONFIG_FILENAME = "abaengine_example_config.xml";
    private Rectangle mInitialFramePosition = null;
    private String mCurrentServerComputerName = "localhost";
    private long mCurrentPortNumber = 40000L;
    private String mCurrentUserName = "Administrator";
    private String mCurrentUserPassword = "eli";
    private int mCurrentMandant = 7777;
    private String mCurrentInputParameters = "";
    private String mCurrentServerExportFileName = "";
    private int mButtonWidth = 230;
    private int mLinePanelHeight = 22;
    private JTextPane m_txpInfoBox = null;
    private JTextField m_txfServerComputerName = null;
    private JTextField m_txfPortNumber = null;
    private JTextField m_txfTimeout = null;
    private JCheckBox m_chkbSSLConnection = null;
    private String mJavaTrustStoreCertificateFile = "private_certs";
    private String mKeystorePassword = "changeit";
    private int mTimeout = 500;
    private JCheckBox m_chkbQueryAsView = null;
    private JCheckBox m_chkbShowLoginOnce = null;
    private JButton mBtnRunReport = null;
    private JComboBox<AbaViewReportType> m_cmbReportType = null;
    private ArrayList<String> mReportNamesList = new ArrayList();
    private String mSelectedReportName = "";
    private JCheckBox m_chkbLogSoapMessages = null;
    private AbaViewReportType[] mReportTypeList = null;
    private AbaViewReportType mDefaultAbaViewReportType = null;
    private int mLoginCount = 0;
    private ReportTable m_tblReportOutput = null;
    private JComboBox<String> m_cmbReportNames = null;
    private JTextField m_txfInputParameters = null;
    private JTextField m_txfServerExportFileName = null;
    private JLabel m_lblUrls = null;
    private String[] mUrls = null;
    private String[] mInterfaceNames = null;
    private Vector mTableRowData = null;
    private Vector mTableHeaderData = null;
    private DefaultTableModel mTableModelData = new DefaultTableModel(){

        @Override
        public int getRowCount() {
            if (StandardExampleFrame.this.getTableRowData() == null) {
                return 3;
            }
            int n = StandardExampleFrame.this.getTableRowData().size();
            return n == 0 ? 3 : n;
        }

        @Override
        public int getColumnCount() {
            if (StandardExampleFrame.this.mTableHeaderData == null) {
                return 5;
            }
            int n = StandardExampleFrame.this.mTableHeaderData.size();
            return n == 0 ? 5 : n;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (StandardExampleFrame.this.getTableRowData() == null) {
                return null;
            }
            int n3 = StandardExampleFrame.this.getTableRowData().size();
            if (n >= n3) {
                return null;
            }
            Vector vector = (Vector)StandardExampleFrame.this.getTableRowData().get(n);
            if (vector == null) {
                return null;
            }
            int n4 = vector.size();
            if (n2 >= n4) {
                return null;
            }
            return vector.get(n2);
        }

        @Override
        public String getColumnName(int n) {
            if (StandardExampleFrame.this.mTableHeaderData == null) {
                return String.valueOf(n + 1);
            }
            int n2 = StandardExampleFrame.this.mTableHeaderData.size();
            if (n >= n2) {
                return String.valueOf(n + 1);
            }
            Object e = StandardExampleFrame.this.mTableHeaderData.get(n);
            return e == null ? "" : e.toString();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (StandardExampleFrame.this.getTableRowData() == null) {
                return;
            }
            int n3 = StandardExampleFrame.this.getTableRowData().size();
            if (n >= n3) {
                return;
            }
            Vector vector = (Vector)StandardExampleFrame.this.getTableRowData().get(n);
            if (vector == null) {
                return;
            }
            int n4 = vector.size();
            if (n2 >= n4) {
                return;
            }
            vector.set(n2, object == null ? "" : object);
        }
    };

    public static void main(String[] stringArray) {
        StandardExampleFrame standardExampleFrame = new StandardExampleFrame();
        standardExampleFrame.initUI();
        standardExampleFrame.setVisible(true);
    }

    public void tableCellSelectionChanged(int n, int n2) {
    }

    protected int getTimeoutMillisecs() {
        String string = this.m_txfTimeout == null ? "" : this.m_txfTimeout.getText();
        int n = this.mTimeout = this.m_txfTimeout == null ? 500 : (int)StandardExampleFrame.convertTextToLong(string, 500L);
        if (this.mTimeout <= 0 || this.mTimeout > 9999999) {
            this.mTimeout = 500;
        }
        if (this.m_txfTimeout != null && !string.equals(String.valueOf(this.mTimeout))) {
            this.m_txfTimeout.setText(String.valueOf(this.mTimeout));
        }
        return this.mTimeout;
    }

    public Vector getTableHeaderData() {
        if (this.mTableHeaderData == null) {
            this.mTableHeaderData = new Vector();
        }
        return this.mTableHeaderData;
    }

    public Vector getTableRowData() {
        if (this.mTableRowData == null) {
            this.mTableRowData = new Vector();
        }
        return this.mTableRowData;
    }

    protected void initUI() {
        this.loadUserSettings();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(5, 5));
        container.add(this.getMainPanel());
        int n = this.mInitialFramePosition == null ? 900 : this.mInitialFramePosition.width;
        int n2 = this.mInitialFramePosition == null ? 600 : this.mInitialFramePosition.height;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = dimension.width > n ? n : dimension.width - 50;
        int n4 = dimension.height > n2 ? n2 : dimension.height - 50;
        int n5 = this.mInitialFramePosition == null ? (dimension.width - n3) / 2 : this.mInitialFramePosition.x;
        int n6 = this.mInitialFramePosition == null ? (dimension.height - n4) / 2 : this.mInitialFramePosition.y;
        URL uRL = StandardExampleFrame.class.getResource("abaviewreport_icon.png");
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            this.setIconImage(imageIcon.getImage());
        }
        this.setSize(n3, n4);
        this.setLocation(n5, n6);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                StandardExampleFrame.this.closeConnection();
                StandardExampleFrame.this.dispose();
            }
        });
        this.mLoginCount = 0;
    }

    protected int getLoginCount() {
        return this.mLoginCount;
    }

    protected void incrementLoginCount() {
        ++this.mLoginCount;
    }

    protected boolean isShowLoginOnceSelected() {
        return this.m_chkbShowLoginOnce != null && this.m_chkbShowLoginOnce.isSelected();
    }

    protected int getCurrentMandant() {
        return this.mCurrentMandant;
    }

    protected void setCurrentMandant(int n) {
        this.mCurrentMandant = n;
    }

    protected String getCurrentUserName() {
        return this.mCurrentUserName;
    }

    protected void setCurrentUserName(String string) {
        this.mCurrentUserName = string;
    }

    protected String getCurrentUserPassword() {
        return this.mCurrentUserPassword;
    }

    protected void setCurrentUserPassword(String string) {
        this.mCurrentUserPassword = string;
    }

    public void setInterfaceNames(String[] stringArray) {
        this.mInterfaceNames = null;
        if (stringArray == null) {
            return;
        }
        if (stringArray.length == 0) {
            return;
        }
        this.mInterfaceNames = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.mInterfaceNames, 0, stringArray.length);
        this.updateUrls();
    }

    private void updateUrls() {
        if (this.mInterfaceNames == null) {
            return;
        }
        if (this.mInterfaceNames.length == 0) {
            return;
        }
        this.mLoginCount = 0;
        this.mUrls = new String[this.mInterfaceNames.length];
        for (int i = 0; i < this.mInterfaceNames.length; ++i) {
            this.mUrls[i] = this.getDefaultUrl(this.getServerComputerName(), this.getPortNumber(), this.mInterfaceNames[i], this.isSSLConnection());
        }
        this.fillUrlTextPane();
    }

    public boolean isSSLConnection() {
        return this.m_chkbSSLConnection == null ? false : this.m_chkbSSLConnection.isSelected();
    }

    private void fillUrlTextPane() {
        if (this.getUrlAddressLabel() == null) {
            return;
        }
        if (this.mUrls == null) {
            return;
        }
        if (this.mUrls.length == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.mUrls) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(string);
        }
        this.getUrlAddressLabel().setText(stringBuilder.toString());
    }

    private String getDefaultUrl(String string, long l, String string2, boolean bl) {
        String string3 = string;
        long l2 = l;
        if (string3 == null || "".equals(string3)) {
            string3 = this.getDefaultComputerName();
        }
        String string4 = bl ? "https" : "http";
        return string4 + "://" + string3 + (l2 > 0L ? ":" + l2 : "") + "/." + (string2 == null ? "" : string2);
    }

    private String getDefaultComputerName() {
        String string = "localhost";
        if (!ACUtilities.StringIsNullOrEmpty(this.mCurrentServerComputerName)) {
            string = this.mCurrentServerComputerName;
        }
        return string;
    }

    protected void closeConnection() {
        this.saveUserSettings();
    }

    private JPanel getMainPanel() {
        JPanel jPanel = UiComponentHelper.getPanelWithBoxLayout(3, -1, -1);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = UiComponentHelper.getPanelWithBoxLayout(3, -1, -1);
        jPanel2.add(this.getComputerNamePortPanel());
        jPanel2.add(Box.createVerticalStrut(6));
        jPanel2.add(this.getUrlListPanel());
        jPanel2.add(Box.createVerticalStrut(6));
        jPanel2.add(this.getReportInputPanel());
        jPanel2.add(Box.createVerticalStrut(4));
        jPanel2.add(this.getReportParametersPanel());
        jPanel2.add(Box.createVerticalStrut(4));
        jPanel2.add(this.getExportFileNamePanel());
        jPanel2.add(Box.createVerticalStrut(4));
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jSplitPane.setOrientation(0);
        jSplitPane.setResizeWeight(0.9);
        jSplitPane.setDividerSize(5);
        jSplitPane.setTopComponent(this.getReportOutputPanel());
        jSplitPane.setBottomComponent(this.getInfoPanel());
        jSplitPane.setAlignmentX(0.5f);
        jSplitPane.setDividerLocation(300);
        jPanel2.add(jSplitPane);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private JPanel getComputerNamePortPanel() {
        JPanel jPanel = UiComponentHelper.getPanelWithBoxLayout(2, -1, this.mLinePanelHeight);
        jPanel.add(UiComponentHelper.getLabel("Server Computer Name :", 150));
        this.m_txfServerComputerName = UiComponentHelper.getTextField("", 230);
        this.m_txfServerComputerName.setText(this.getDefaultComputerName());
        jPanel.add(this.m_txfServerComputerName);
        jPanel.add(Box.createHorizontalStrut(20));
        jPanel.add(UiComponentHelper.getLabel("Port :", 40));
        this.m_txfPortNumber = UiComponentHelper.getTextField("", 60);
        this.m_txfPortNumber.setText(this.mCurrentPortNumber <= 0L ? "40000" : String.valueOf(this.mCurrentPortNumber));
        jPanel.add(this.m_txfPortNumber);
        this.m_chkbSSLConnection = UiComponentHelper.getCheckBox("Use SSL", 80);
        this.m_chkbSSLConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StandardExampleFrame.this.action_UseSSLChanged();
            }
        });
        this.m_chkbShowLoginOnce = UiComponentHelper.getCheckBox("Show login dialog 1st time only", this.mButtonWidth);
        this.m_chkbShowLoginOnce.setSelected(true);
        jPanel.add(Box.createHorizontalStrut(20));
        jPanel.add(this.m_chkbSSLConnection);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.m_chkbShowLoginOnce);
        this.m_txfServerComputerName.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                StandardExampleFrame.this.action_ComputerNameChanged();
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.m_txfPortNumber.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                StandardExampleFrame.this.action_PortNumberChanged();
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.m_txfServerComputerName.setToolTipText("<html>Server Computer Name</html>");
        this.m_txfPortNumber.setToolTipText("<html>Port Number</html>");
        this.m_chkbShowLoginOnce.setToolTipText("<html>Check to show the login dialog once or<br>uncheck to show login for every query.</html>");
        return jPanel;
    }

    private JLabel getUrlAddressLabel() {
        if (this.m_lblUrls == null) {
            this.m_lblUrls = UiComponentHelper.getLabel("", -1);
        }
        return this.m_lblUrls;
    }

    private JPanel getUrlListPanel() {
        JPanel jPanel = UiComponentHelper.getPanelWithBoxLayout(2, -1, this.mLinePanelHeight);
        jPanel.add(UiComponentHelper.getLabel("AbaEngine Service URL :", 150));
        jPanel.add(this.getUrlAddressLabel());
        this.m_txfTimeout = UiComponentHelper.getTextField("", 50);
        this.m_txfTimeout.setText(String.valueOf(this.mTimeout));
        String string = "Timeout (ms) : ";
        int n = this.getFontMetricsStringWidth(string, 80);
        jPanel.add(UiComponentHelper.getLabel(string, n));
        jPanel.add(this.m_txfTimeout);
        jPanel.add(Box.createHorizontalStrut(10));
        string = "Log Soap Messages";
        this.m_chkbLogSoapMessages = UiComponentHelper.getCheckBox(string, this.getFontMetricsStringWidth(string, 120) + 25);
        jPanel.add(Box.createHorizontalStrut(30));
        jPanel.add(this.m_chkbLogSoapMessages);
        return jPanel;
    }

    private JPanel getReportInputPanel() {
        JPanel jPanel = UiComponentHelper.getPanelWithBoxLayout(2, -1, this.mLinePanelHeight);
        jPanel.add(UiComponentHelper.getLabel("AbaView Report Name :", 150));
        this.m_cmbReportNames = new JComboBox();
        this.m_cmbReportNames.setMinimumSize(new Dimension(10, 20));
        this.m_cmbReportNames.setMaximumSize(new Dimension(9999, 20));
        this.m_cmbReportNames.setPreferredSize(new Dimension(500, 20));
        this.m_cmbReportNames.setEditable(true);
        this.m_cmbReportNames.setMaximumRowCount(20);
        this.mBtnRunReport = UiComponentHelper.getButton("Run Report", this.mButtonWidth);
        String string = "Use OpenView";
        this.m_chkbQueryAsView = UiComponentHelper.getCheckBox(string, this.getFontMetricsStringWidth(string, 120) + 25);
        jPanel.add(this.m_cmbReportNames);
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(this.m_chkbQueryAsView);
        jPanel.add(Box.createHorizontalStrut(30));
        jPanel.add(this.mBtnRunReport);
        this.m_cmbReportNames.setToolTipText("<html>AbaView Report Name can be typed or selected with the<br>mouse from the table when report names are shown.</html>");
        this.mBtnRunReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StandardExampleFrame.this.action_runReport();
            }
        });
        if (this.mReportNamesList != null && this.mReportNamesList.size() > 0) {
            this.m_cmbReportNames.setModel(new DefaultComboBoxModel<String>(this.mReportNamesList.toArray(new String[0])));
            this.mBtnRunReport.setEnabled(true);
        } else {
            this.mBtnRunReport.setEnabled(false);
        }
        if (!ACUtilities.StringIsNullOrEmpty(this.mSelectedReportName)) {
            this.m_cmbReportNames.setSelectedItem(this.mSelectedReportName);
        }
        this.m_cmbReportNames.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                StandardExampleFrame.this.mBtnRunReport.setEnabled(!"".equals(StandardExampleFrame.this.getReportName()));
            }
        });
        return jPanel;
    }

    private int getFontMetricsStringWidth(String string, int n) {
        int n2 = n;
        if (string != null && !"".equals(string)) {
            n2 = this.getUrlAddressLabel().getFontMetrics(this.getUrlAddressLabel().getFont()).stringWidth(string);
        }
        return n2;
    }

    private AbaViewReportType[] getAbaReportTypes() {
        ArrayList<AbaViewReportType> arrayList = new ArrayList<AbaViewReportType>();
        String[] stringArray = new String[]{"ansi", "ascii", "UTF-8", "UTF-16"};
        this.mDefaultAbaViewReportType = new AbaViewReportType("Text", "txt", "txt", stringArray);
        arrayList.add(this.mDefaultAbaViewReportType);
        arrayList.add(new AbaViewReportType("Pdf", "pdf", "pdf"));
        arrayList.add(new AbaViewReportType("PrintText", "print-txt", "txt"));
        arrayList.add(new AbaViewReportType("TextAll", "txt_all", "txt", stringArray));
        arrayList.add(new AbaViewReportType("HtmlEndless", "html_endless", "html"));
        arrayList.add(new AbaViewReportType("HtmlTable", "html_table", "html"));
        arrayList.add(new AbaViewReportType("HtmlAutoTable", "html_autotable", "html"));
        arrayList.add(new AbaViewReportType("ExcelData", "excel-xlsx_data", "xlsx"));
        arrayList.add(new AbaViewReportType("ExcelMatrix", "excel-xlsx_matrix", "xlsx"));
        arrayList.add(new AbaViewReportType("Excel", "excel-xlsx", "xls"));
        arrayList.add(new AbaViewReportType("Word", "word-docx", "docx"));
        arrayList.add(new AbaViewReportType("XmlAttribute", "xml_attr", "xml", stringArray));
        arrayList.add(new AbaViewReportType("XmlValue", "xml_value", "xml", stringArray));
        arrayList.add(new AbaViewReportType("XmlNameValue", "xml_namevalue", "xml", stringArray));
        arrayList.add(new AbaViewReportType("XmlAv", "xml_av", "xml", stringArray));
        arrayList.add(new AbaViewReportType("XmlPreview", "xml_preview", "xml"));
        arrayList.add(new AbaViewReportType("Excel", "excel", "xls"));
        arrayList.add(new AbaViewReportType("ExcelData", "excel_data", "xls"));
        arrayList.add(new AbaViewReportType("Word", "word", "docx"));
        arrayList.add(new AbaViewReportType("XmlQuery", "xml_query", "xml"));
        arrayList.add(new AbaViewReportType("Print", "print", "txt"));
        Collections.sort(arrayList);
        return arrayList.toArray(new AbaViewReportType[0]);
    }

    public String getReportAbaEngineOutputDevice(String string) {
        String string2 = "txt";
        if (this.mReportTypeList == null || string == null || "".equals(string)) {
            return string2;
        }
        if (this.mReportTypeList.length > 0) {
            int n = 0;
            for (AbaViewReportType abaViewReportType : this.mReportTypeList) {
                if (!string.equals(abaViewReportType.getAbaReportType())) continue;
                string2 = abaViewReportType.getAbaEngineOutputDevice();
                ++n;
            }
            if (n > 1) {
                throw new IllegalStateException("Multiple Report Types detected !!");
            }
        }
        return string2;
    }

    public String getReportFileExtension(String string) {
        String string2 = "txt";
        if (this.mReportTypeList == null || string == null || "".equals(string)) {
            return string2;
        }
        if (this.mReportTypeList.length > 0) {
            int n = 0;
            for (AbaViewReportType abaViewReportType : this.mReportTypeList) {
                if (!string.equals(abaViewReportType.getAbaReportType())) continue;
                string2 = abaViewReportType.getFileExtension();
                ++n;
            }
            if (n > 1) {
                throw new IllegalStateException("Multiple Report Types detected !!");
            }
        }
        return string2;
    }

    public boolean getReportSupportsEncoding(String string, String string2) {
        boolean bl = false;
        if (this.mReportTypeList == null || string == null || "".equals(string)) {
            return bl;
        }
        if (this.mReportTypeList.length > 0) {
            int n = 0;
            for (AbaViewReportType abaViewReportType : this.mReportTypeList) {
                if (!string.equals(abaViewReportType.getAbaReportType())) continue;
                bl = abaViewReportType.supportsEncoding(string2);
                ++n;
            }
            if (n > 1) {
                throw new IllegalStateException("Multiple Report Types detected !!");
            }
        }
        return bl;
    }

    private JPanel getReportParametersPanel() {
        JPanel jPanel = UiComponentHelper.getPanelWithBoxLayout(2, -1, this.mLinePanelHeight);
        jPanel.add(UiComponentHelper.getLabel("Input Parameters :", 150));
        this.m_txfInputParameters = UiComponentHelper.getTextField("", 0);
        this.m_txfInputParameters.setText(this.mCurrentInputParameters);
        this.mReportTypeList = this.getAbaReportTypes();
        int n = 90;
        JLabel jLabel = UiComponentHelper.getLabel("Report Type :", n);
        this.m_cmbReportType = new JComboBox<AbaViewReportType>(this.mReportTypeList);
        int n2 = this.mButtonWidth - n;
        this.m_cmbReportType.setMinimumSize(new Dimension(n2, 20));
        this.m_cmbReportType.setMaximumSize(new Dimension(n2, 20));
        this.m_cmbReportType.setPreferredSize(new Dimension(n2, 20));
        this.m_cmbReportType.setMaximumRowCount(25);
        if (this.mDefaultAbaViewReportType != null) {
            this.m_cmbReportType.setSelectedItem(this.mDefaultAbaViewReportType);
        }
        jPanel.add(this.m_txfInputParameters);
        jPanel.add(Box.createHorizontalStrut(30));
        jPanel.add(jLabel);
        jPanel.add(this.m_cmbReportType);
        this.m_txfInputParameters.setToolTipText("<html>Report input parameters separated by semi-colon<br>(e.g. FROM_DATE=01/01/2007;TO_DATE=01/10/2007 where<br> FROM_DATE and TO_DATE are the names of AbaView report input fields)</html>");
        return jPanel;
    }

    public String getSelectedAbaViewReportType() {
        if (this.m_cmbReportType == null) {
            return "txt";
        }
        Object object = this.m_cmbReportType.getSelectedItem();
        return object == null ? "txt" : object.toString();
    }

    private JPanel getExportFileNamePanel() {
        JPanel jPanel = UiComponentHelper.getPanelWithBoxLayout(2, -1, this.mLinePanelHeight);
        jPanel.add(UiComponentHelper.getLabel("Server Export File :", 150));
        this.m_txfServerExportFileName = UiComponentHelper.getTextField("", 0);
        this.m_txfServerExportFileName.setText(this.mCurrentServerExportFileName);
        jPanel.add(this.m_txfServerExportFileName);
        jPanel.add(Box.createHorizontalStrut(30));
        jPanel.add(Box.createHorizontalStrut(this.mButtonWidth));
        this.m_txfServerExportFileName.setToolTipText("Path name of export file on the Server (e.g. c:\\test.txt)");
        return jPanel;
    }

    private JPanel getReportOutputPanel() {
        JPanel jPanel = UiComponentHelper.getPanelWithBoxLayout(2, -1, -1);
        this.m_tblReportOutput = new ReportTable();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setMaximumSize(new Dimension(9999, 9999));
        jScrollPane.setMinimumSize(new Dimension(20, 20));
        jScrollPane.setPreferredSize(new Dimension(1100, 300));
        jScrollPane.setViewportView(this.m_tblReportOutput);
        this.m_tblReportOutput.setModel(this.mTableModelData);
        jPanel.add(jScrollPane);
        return jPanel;
    }

    private JPanel getInfoPanel() {
        JPanel jPanel = UiComponentHelper.getPanelWithBoxLayout(2, -1, -1);
        this.m_txpInfoBox = new JTextPane();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setMaximumSize(new Dimension(9999, 9999));
        jScrollPane.setMinimumSize(new Dimension(20, 20));
        jScrollPane.setPreferredSize(new Dimension(1100, 300));
        jScrollPane.setViewportView(this.m_txpInfoBox);
        jPanel.add(jScrollPane);
        this.m_txpInfoBox.setEditable(false);
        this.m_txpInfoBox.setBackground(new Color(250, 250, 250));
        return jPanel;
    }

    private String getOutputPaneText() {
        return this.m_txpInfoBox == null ? "" : this.m_txpInfoBox.getText();
    }

    protected void writeToOutputPane(String string) {
        if (this.m_txpInfoBox != null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = "\r\n";
            String string3 = this.m_txpInfoBox.getText();
            stringBuilder.append(string3);
            if (stringBuilder.length() > 0 && !string3.endsWith(string2)) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(string);
            stringBuilder.append(string2);
            this.m_txpInfoBox.setText(stringBuilder.toString());
            int n = this.m_txpInfoBox.getText().replace(string2, "").length() - 1;
            if (n < 0) {
                n = 0;
            }
            try {
                this.m_txpInfoBox.scrollRectToVisible(this.m_txpInfoBox.modelToView(n));
                this.m_txpInfoBox.updateUI();
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    protected void scrollOutputPaneToStart() {
        if (this.m_txpInfoBox != null) {
            this.m_txpInfoBox.setCaretPosition(0);
            this.m_txpInfoBox.scrollRectToVisible(new Rectangle(0, 0, 2, 2));
        }
    }

    public void refreshReportTable() {
        if (this.m_tblReportOutput == null) {
            return;
        }
        this.mTableModelData.fireTableDataChanged();
        this.mTableModelData.fireTableStructureChanged();
        this.m_tblReportOutput.updateUI();
    }

    protected void showMessageBox(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    protected void showMessageBox(String string, String string2) {
        JOptionPane.showMessageDialog(this, string, string2, 1);
    }

    protected int showConfirmMessageBox(String string, String string2) {
        return this.showConfirmMessageBox(string, string2, 2);
    }

    protected int showConfirmMessageBox(String string, String string2, int n) {
        return JOptionPane.showConfirmDialog(this, string, string2, n);
    }

    protected boolean isQueryAsOpenView() {
        if (this.m_chkbQueryAsView == null) {
            return false;
        }
        return this.m_chkbQueryAsView.isSelected();
    }

    protected boolean isLogSoapMessagesActive() {
        if (this.m_chkbLogSoapMessages == null) {
            return false;
        }
        return this.m_chkbLogSoapMessages.isSelected();
    }

    protected String getReportName() {
        String string = "";
        if (this.m_cmbReportNames == null) {
            return string;
        }
        ComboBoxEditor comboBoxEditor = this.m_cmbReportNames.getEditor();
        if (comboBoxEditor == null) {
            return string;
        }
        Object object = comboBoxEditor.getItem();
        if (object != null) {
            string = object.toString();
        }
        return string;
    }

    protected void addReportName(String string) {
        if (this.m_cmbReportNames == null || ACUtilities.StringIsNullOrEmpty(string)) {
            return;
        }
        int n = this.m_cmbReportNames.getItemCount();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.m_cmbReportNames.getItemAt(i))) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.m_cmbReportNames.addItem(string);
        }
    }

    private void saveUserSettings() {
        if (this.m_cmbReportNames != null) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            String string = ACUtilities.getOperatingSystemLineSeparator();
            String string2 = "  ";
            stringBuilder.append("<?xml version='1.0' encoding='utf-8'?>");
            stringBuilder.append(string);
            stringBuilder.append("<AbaEngineExampleConfiguration>");
            stringBuilder.append(string);
            stringBuilder.append(string2);
            stringBuilder.append("<Settings>");
            stringBuilder.append(string);
            stringBuilder.append(string2);
            stringBuilder.append(string2);
            stringBuilder.append("<ServerName>");
            stringBuilder.append(this.getServerComputerName());
            stringBuilder.append("</ServerName>");
            stringBuilder.append(string);
            stringBuilder.append(string2);
            stringBuilder.append(string2);
            stringBuilder.append("<PortNumber>");
            stringBuilder.append(this.getPortNumber());
            stringBuilder.append("</PortNumber>");
            stringBuilder.append(string);
            stringBuilder.append(string2);
            stringBuilder.append(string2);
            stringBuilder.append("<Username>");
            stringBuilder.append(this.mCurrentUserName);
            stringBuilder.append("</Username>");
            stringBuilder.append(string);
            stringBuilder.append(string2);
            stringBuilder.append(string2);
            stringBuilder.append("<Mandant>");
            stringBuilder.append(this.mCurrentMandant);
            stringBuilder.append("</Mandant>");
            stringBuilder.append(string);
            this.mInitialFramePosition = this.getBounds();
            stringBuilder.append(string2);
            stringBuilder.append(string2);
            stringBuilder.append("<FramePosition>");
            stringBuilder.append(String.format("%d,%d,%d,%d", this.mInitialFramePosition.x, this.mInitialFramePosition.y, this.mInitialFramePosition.width, this.mInitialFramePosition.height));
            stringBuilder.append("</FramePosition>");
            stringBuilder.append(string);
            stringBuilder.append(string2);
            stringBuilder.append(string2);
            stringBuilder.append("<TimeOutMillisecs>");
            stringBuilder.append(this.getTimeoutMillisecs());
            stringBuilder.append("</TimeOutMillisecs>");
            stringBuilder.append(string);
            stringBuilder.append(string2);
            stringBuilder.append(string2);
            stringBuilder.append("<LogSoapMessages>");
            stringBuilder.append(this.isLogSoapMessagesActive() ? "true" : "false");
            stringBuilder.append("</LogSoapMessages>");
            stringBuilder.append(string);
            stringBuilder.append(string2);
            stringBuilder.append(string2);
            stringBuilder.append("<InputParameters>");
            stringBuilder.append(this.getInputParameters());
            stringBuilder.append("</InputParameters>");
            stringBuilder.append(string);
            stringBuilder.append(string2);
            stringBuilder.append(string2);
            stringBuilder.append("<ServerExportFileName>");
            stringBuilder.append(this.getServerExportFileName());
            stringBuilder.append("</ServerExportFileName>");
            stringBuilder.append(string);
            stringBuilder.append(string2);
            stringBuilder.append("</Settings>");
            stringBuilder.append(string);
            stringBuilder.append(string2);
            stringBuilder.append("<ReportNamesList>");
            stringBuilder.append(string);
            String string3 = this.getReportName();
            int n = this.m_cmbReportNames.getItemCount();
            for (int i = 0; i < n; ++i) {
                object = this.m_cmbReportNames.getItemAt(i);
                if (object == null) continue;
                stringBuilder.append(string2);
                stringBuilder.append(string2);
                stringBuilder.append("<ReportName");
                if (object.equals(string3)) {
                    stringBuilder.append(" selected=\"true\"");
                }
                stringBuilder.append(">");
                stringBuilder.append(object);
                stringBuilder.append("</ReportName>");
                stringBuilder.append(string);
            }
            stringBuilder.append(string2);
            stringBuilder.append("</ReportNamesList>");
            stringBuilder.append(string);
            stringBuilder.append("</AbaEngineExampleConfiguration>");
            stringBuilder.append(string);
            if (stringBuilder.length() > 0) {
                try {
                    String string4 = ACUtilities.getCurrentUserWorkingDirectory() + File.separator + EXAMPLE_CONFIG_FILENAME;
                    object = new BufferedOutputStream(new FileOutputStream(string4));
                    ((FilterOutputStream)object).write(stringBuilder.toString().getBytes(StandardCharsets.UTF_8));
                    ((FilterOutputStream)object).close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private void loadUserSettings() {
        String string = ACUtilities.getCurrentUserWorkingDirectory() + File.separator + EXAMPLE_CONFIG_FILENAME;
        if (new File(string).exists()) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(string);
                document.getDocumentElement().normalize();
                String string2 = document.getDocumentElement().getNodeName();
                this.mSelectedReportName = "";
                if ("AbaEngineExampleConfiguration".equals(string2)) {
                    Element element;
                    String string3;
                    Node node;
                    int n;
                    NodeList nodeList = document.getElementsByTagName("ReportName");
                    for (n = 0; n < nodeList.getLength(); ++n) {
                        node = nodeList.item(n);
                        if (node.getNodeType() != 1 || ACUtilities.StringIsNullOrEmpty(string3 = (element = (Element)node).getTextContent())) continue;
                        if (!this.mReportNamesList.contains(string3)) {
                            this.mReportNamesList.add(string3);
                        }
                        if (element.hasAttribute("selected")) {
                            if (!"true".equalsIgnoreCase(element.getAttribute("selected"))) continue;
                            this.mSelectedReportName = string3;
                            continue;
                        }
                        if (!ACUtilities.StringIsNullOrEmpty(this.mSelectedReportName)) continue;
                        this.mSelectedReportName = string3;
                    }
                    nodeList = document.getElementsByTagName("Settings");
                    for (n = 0; n < nodeList.getLength(); ++n) {
                        String[] stringArray;
                        node = nodeList.item(n);
                        if (node.getNodeType() != 1) continue;
                        element = (Element)node;
                        string3 = StandardExampleFrame.getTextContent(element, "ServerName");
                        if (!ACUtilities.StringIsNullOrEmpty(string3)) {
                            this.setServerComputerName(string3.trim());
                        }
                        if (!ACUtilities.StringIsNullOrEmpty(string3 = StandardExampleFrame.getTextContent(element, "PortNumber"))) {
                            this.setPortNumber(ACUtilities.convertTextToLong(string3.trim(), 40000L));
                        }
                        if (!ACUtilities.StringIsNullOrEmpty(string3 = StandardExampleFrame.getTextContent(element, "Username"))) {
                            this.mCurrentUserName = string3.trim();
                        }
                        if (!ACUtilities.StringIsNullOrEmpty(string3 = StandardExampleFrame.getTextContent(element, "Password"))) {
                            this.mCurrentUserPassword = string3.trim();
                        }
                        if (!ACUtilities.StringIsNullOrEmpty(string3 = StandardExampleFrame.getTextContent(element, "Mandant"))) {
                            this.mCurrentMandant = (int)ACUtilities.convertTextToLong(string3.trim(), 7777L);
                        }
                        if (!ACUtilities.StringIsNullOrEmpty(string3 = StandardExampleFrame.getTextContent(element, "FramePosition")) && (stringArray = string3.split(",")).length > 3) {
                            int n2 = (int)StandardExampleFrame.convertTextToLong(stringArray[0], -1L);
                            int n3 = (int)StandardExampleFrame.convertTextToLong(stringArray[1], -1L);
                            int n4 = (int)StandardExampleFrame.convertTextToLong(stringArray[2], -1L);
                            int n5 = (int)StandardExampleFrame.convertTextToLong(stringArray[3], -1L);
                            if (n2 >= 0 && n3 >= 0 && n5 > 0 && n4 > 0) {
                                this.mInitialFramePosition = new Rectangle(n2, n3, n4, n5);
                            }
                        }
                        if (!ACUtilities.StringIsNullOrEmpty(string3 = StandardExampleFrame.getTextContent(element, "InputParameters"))) {
                            this.mCurrentInputParameters = string3.trim();
                        }
                        if (!ACUtilities.StringIsNullOrEmpty(string3 = StandardExampleFrame.getTextContent(element, "ServerExportFileName"))) {
                            this.mCurrentServerExportFileName = string3.trim();
                        }
                        if (ACUtilities.StringIsNullOrEmpty(string3 = StandardExampleFrame.getTextContent(element, "TimeOutMillisecs"))) continue;
                        this.mTimeout = (int)StandardExampleFrame.convertTextToLong(string3.trim(), 500L);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.mReportNamesList.size() > 1) {
            Collections.sort(this.mReportNamesList);
        }
    }

    private static String getTextContent(Element element, String string) {
        Node node;
        NodeList nodeList;
        String string2 = "";
        if (element != null && (nodeList = element.getElementsByTagName(string)) != null && nodeList.getLength() > 0 && (node = nodeList.item(0)) != null) {
            string2 = node.getTextContent();
        }
        return string2 == null ? "" : string2;
    }

    protected String getInputParameters() {
        return this.m_txfInputParameters == null ? "" : this.m_txfInputParameters.getText();
    }

    protected String getServerExportFileName() {
        String string = this.m_txfServerExportFileName == null ? "" : this.m_txfServerExportFileName.getText();
        return string.replace("/", "\\");
    }

    protected void setReportName(String string) {
        if (this.m_cmbReportNames != null) {
            this.m_cmbReportNames.setSelectedItem(string == null ? "" : string);
        }
    }

    static long convertTextToLong(String string, long l) {
        long l2;
        try {
            l2 = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            l2 = l;
        }
        return l2;
    }

    static String removeQuotes(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string.trim();
        if (string2.startsWith("\"")) {
            string2 = string2.substring(1);
        }
        if (string2.endsWith("\"")) {
            string2 = string2.length() <= 1 ? "" : string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public String getAbaEngineUrl() {
        return this.getAbaEngineUrl(this.getServerComputerName(), this.getPortNumber());
    }

    private String getAbaEngineUrl(String string, long l) {
        String string2 = "http";
        if (this.isSSLConnection()) {
            string2 = "https";
            this.initializeCertificateTrustStore();
        }
        if (string == null || "".equals(string)) {
            return string2 + "://localhost" + (l > 0L ? ":" + l : "") + "/.abaengine";
        }
        return string2 + "://" + string + (l > 0L ? ":" + l : "") + "/.abaengine";
    }

    private void initializeCertificateTrustStore() {
        String string = this.mJavaTrustStoreCertificateFile;
        String string2 = File.separator;
        String string3 = System.getProperty("java.home") + string2 + "lib" + string2 + "security";
        String string4 = string3 + string2 + string;
        if (!new File(string4).exists()) {
            string = "cacerts";
            string4 = string3 + string2 + string;
        }
        if (new File(string4).exists()) {
            String string5 = System.getProperty("javax.net.ssl.trustStore");
            if (!string4.equals(string5)) {
                System.setProperty("javax.net.ssl.trustStore", string4);
                System.setProperty("javax.net.ssl.trustStorePassword", this.mKeystorePassword);
            }
            String string6 = "INFO : Java TrustStore using : " + string4;
            if (!this.getOutputPaneText().contains(string6)) {
                this.writeToOutputPane("");
                this.writeToOutputPane(string6);
            }
        } else {
            this.writeToOutputPane("WARNING : No JAVA TrustStore available in : " + string3);
            this.writeToOutputPane("WARNING : Looking for certificate KeyStore in : " + string3 + string2 + string);
            this.writeToOutputPane("             or otherwise in JAVA KeyStore in : " + string4);
        }
    }

    private String getServerComputerName() {
        return this.m_txfServerComputerName == null ? "" : this.m_txfServerComputerName.getText();
    }

    public void setServerComputerName(String string) {
        if (this.m_txfServerComputerName != null) {
            this.m_txfServerComputerName.setText(string == null ? "localhost" : string);
        }
        this.mCurrentServerComputerName = string == null ? "localhost" : string;
    }

    private long getPortNumber() {
        String string;
        String string2 = string = this.m_txfPortNumber == null ? "" : this.m_txfPortNumber.getText();
        if ("".equals(string)) {
            string = "40000";
            if (this.m_txfPortNumber != null) {
                this.m_txfPortNumber.setText(string);
            }
        }
        return StandardExampleFrame.convertTextToLong(string, 40000L);
    }

    public void setPortNumber(long l) {
        if (this.m_txfPortNumber != null) {
            this.m_txfPortNumber.setText(l <= 0L ? "40000" : String.valueOf(l));
        }
        this.mCurrentPortNumber = l <= 0L ? 40000L : l;
    }

    public void action_runReport() {
        System.out.println("NOT IMPLEMENTED : StandardExampleFrame:action_runReport() called");
    }

    public void action_ComputerNameChanged() {
        String string = this.m_txfServerComputerName.getText();
        if ("l".equals(string)) {
            string = "localhost";
            this.m_txfServerComputerName.setText(string);
            this.m_txfServerComputerName.setSelectionStart(1);
        }
        this.updateUrls();
    }

    public void action_PortNumberChanged() {
        this.updateUrls();
    }

    public void clearInfo() {
        if (this.m_txpInfoBox != null) {
            this.m_txpInfoBox.setText("");
        }
    }

    private void action_UseSSLChanged() {
        this.updateUrls();
        if (this.isSSLConnection()) {
            String string = this.mJavaTrustStoreCertificateFile;
            String string2 = File.separator;
            String string3 = System.getProperty("java.home") + string2 + "lib" + string2 + "security";
            String string4 = string3 + string2 + string;
            if (!new File(string4).exists()) {
                string = "cacerts";
                string4 = string3 + string2 + string;
            }
            if (new File(string4).exists()) {
                String string5 = "INFO : Java TrustStore using : " + string4;
                if (!this.getOutputPaneText().contains(string5)) {
                    this.writeToOutputPane("");
                    this.writeToOutputPane(string5);
                }
            }
        }
    }

    class ReportTable
    extends JTable {
        ReportTable() {
        }

        @Override
        public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
            StandardExampleFrame.this.tableCellSelectionChanged(n, n2);
            super.changeSelection(n, n2, bl, bl2);
        }
    }
}

