/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.testapp;

import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class ACUtilities {
    static SimpleDateFormat m_DateFormatter = new SimpleDateFormat("dd.MM.yyyy");
    static SimpleDateFormat m_DateTimeFormatter = new SimpleDateFormat("dd.MM.yyyy HH.mm:ss");

    public static String convertDateToString(Date date) {
        String string = "";
        if (date == null) {
            return string;
        }
        string = m_DateFormatter.format(date);
        return string;
    }

    public static String convertDateToTimeString(long l) {
        String string = "";
        if (l <= 0L) {
            return string;
        }
        string = ACUtilities.convertDateToTimeString(new Date(l));
        return string;
    }

    public static String convertDateToTimeString(Date date) {
        String string = "";
        if (date == null) {
            return string;
        }
        string = m_DateTimeFormatter.format(date);
        if (!ACUtilities.StringIsNullOrEmpty(string)) {
            string = string.length() > 12 ? string.substring(11) : "";
        }
        return string;
    }

    public static String convertDateToString(long l) {
        String string = "";
        if (l <= 0L) {
            return string;
        }
        string = ACUtilities.convertDateToString(new Date(l));
        return string;
    }

    public static boolean StringIsNullOrEmpty(String string) {
        return string == null || "".equals(string);
    }

    public static String convertDateTimeToString(long l) {
        String string = "";
        if (l <= 0L) {
            return string;
        }
        string = ACUtilities.convertDateTimeToString(new Date(l));
        return string;
    }

    public static String convertDateTimeToString(Date date) {
        String string = "";
        if (date == null) {
            return string;
        }
        string = m_DateTimeFormatter.format(date);
        return string;
    }

    public static BigDecimal convertDoubleToBigDecimal(double d) {
        return ACUtilities.convertDoubleToBigDecimal(d, -1);
    }

    public static BigDecimal convertDoubleToBigDecimal(double d, int n) {
        String string = String.valueOf(d);
        return new BigDecimal(string);
    }

    public static String getCurrentUserWorkingDirectory() {
        return System.getProperty("user.dir");
    }

    public static String getOperatingSystemLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String getOperatingSystemName() {
        return System.getProperty("os.name");
    }

    public static boolean isLinuxOperatingSystem() {
        String string = ACUtilities.getOperatingSystemName();
        if (ACUtilities.StringIsNullOrEmpty(string)) {
            return false;
        }
        return string.toLowerCase().contains("linux");
    }

    public static long convertTextToLong(String string, long l) {
        long l2;
        try {
            l2 = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            l2 = l;
        }
        return l2;
    }

    public static String getCurrentProgramVersionInfo() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(System.currentTimeMillis());
        int n = gregorianCalendar.get(1);
        String string = " : JA-V";
        String string2 = string + String.valueOf(n - 2001) + ".12-0";
        String string3 = "version.txt";
        URL uRL = ACUtilities.class.getResource(string3);
        InputStream inputStream = null;
        if (uRL != null) {
            try {
                int n2;
                inputStream = uRL.openStream();
                int n3 = 256;
                byte[] byArray = new byte[n3];
                while ((n2 = inputStream.read(byArray, 0, n3)) != -1) {
                    String string4 = new String(byArray, 0, n2);
                    if (ACUtilities.StringIsNullOrEmpty(string4)) continue;
                    int n4 = string4.indexOf("\n");
                    if (n4 > 0) {
                        string4 = string4.substring(0, n4).trim();
                    }
                    if ((n4 = string4.indexOf("\r")) > 0) {
                        string4 = string4.substring(0, n4).trim();
                    }
                    if ((n4 = string4.indexOf(".")) == 4) {
                        string2 = string + string4.substring(2).trim();
                        continue;
                    }
                    if (n4 <= 0) continue;
                    string2 = string + string4.trim();
                }
                inputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return string2;
            }
        }
        return string2;
    }
}

